/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util.comparator;

import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.util.OrderByComparator;

public class OrganizationTypeComparator
extends OrderByComparator<Organization> {
    public static final String ORDER_BY_ASC = "orgType ASC, orgName ASC";
    public static final String ORDER_BY_DESC = "orgType DESC, orgName DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"type", "name"};
    private final boolean _ascending;

    public OrganizationTypeComparator() {
        this(false);
    }

    public OrganizationTypeComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Organization organization1, Organization organization2) {
        int typeOrder2;
        int typeOrder1 = organization1.getTypeOrder();
        int value = typeOrder1 - (typeOrder2 = organization2.getTypeOrder());
        if (value == 0) {
            String name1 = organization1.getName();
            String name2 = organization2.getName();
            value = name1.compareTo(name2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

