/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checks.configuration.SourceFormatterSuppressions;
import com.liferay.source.formatter.checkstyle.util.CheckstyleLogger;
import com.liferay.source.formatter.checkstyle.util.CheckstyleUtil;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Checker
extends com.puppycrawl.tools.checkstyle.Checker {
    private static final Log _log = LogFactoryUtil.getLog(Checker.class);
    private final AuditListener _auditListener;
    private final CheckstyleLogger _checkstyleLogger;
    private final ClassLoader _classLoader;
    private final Configuration _configuration;
    private final FilterSet _filterSet;
    private final ModuleFactory _moduleFactory;

    public Checker(Configuration configuration, AuditListener auditListener, CheckstyleLogger checkstyleLogger, SourceFormatterSuppressions sourceFormatterSuppressions) throws CheckstyleException {
        this._configuration = configuration;
        this._auditListener = auditListener;
        this._checkstyleLogger = checkstyleLogger;
        this._checkstyleLogger.clearSourceFormatterMessages();
        this._filterSet = sourceFormatterSuppressions.getCheckstyleFilterSet();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        this._classLoader = clazz.getClassLoader();
        this.setModuleClassLoader(this._classLoader);
        this._moduleFactory = new PackageObjectFactory(PackageNamesLoader.getPackageNames((ClassLoader)this._classLoader), this._classLoader);
        this.addFilter((Filter)this._filterSet);
        this.addListener(this._auditListener);
        this.configure(this._configuration);
    }

    public void fireErrors(String fileName, SortedSet<LocalizedMessage> errors) {
        super.fireErrors(this._normalizeFileName(fileName), errors);
    }

    public void fireFileFinished(String fileName) {
        super.fireFileFinished(this._normalizeFileName(fileName));
    }

    public void fireFileStarted(String fileName) {
        super.fireFileStarted(this._normalizeFileName(fileName));
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return this._checkstyleLogger.getSourceFormatterMessages();
    }

    public void processFileContents(List<String[]> fileContents) throws CheckstyleException, IOException {
        this._fireAuditStarted();
        for (Configuration childConfiguration : this._configuration.getChildren()) {
            Object childModule = this._moduleFactory.createModule(childConfiguration.getName());
            if (!(childModule instanceof TreeWalker)) continue;
            TreeWalker treeWalker = (TreeWalker)childModule;
            this._processFileContents(fileContents, this._getChecks(childConfiguration));
            treeWalker.finishProcessing();
            treeWalker.destroy();
        }
        this._fireAuditStarted();
    }

    private void _fireAuditStarted() {
        this._auditListener.auditStarted(new AuditEvent((Object)this));
    }

    private List<AbstractCheck> _getChecks(Configuration configuration) throws CheckstyleException {
        ArrayList<AbstractCheck> checks = new ArrayList<AbstractCheck>();
        for (Configuration checkConfiguration : configuration.getChildren()) {
            Object checkModule = this._moduleFactory.createModule(checkConfiguration.getName());
            if (!(checkModule instanceof AbstractCheck)) continue;
            AbstractCheck check = (AbstractCheck)checkModule;
            check.configure(checkConfiguration);
            checks.add(check);
        }
        return checks;
    }

    private boolean _isRegisteredCheck(AbstractCheck check, int tokenType) {
        Set tokenNames = check.getTokenNames();
        if (tokenNames.isEmpty()) {
            return ArrayUtil.contains(check.getDefaultTokens(), tokenType);
        }
        if (!ArrayUtil.contains(check.getAcceptableTokens(), tokenType)) {
            return false;
        }
        for (String tokenName : tokenNames) {
            if (tokenType != TokenUtil.getTokenId((String)tokenName)) continue;
            return true;
        }
        return false;
    }

    private String _normalizeFileName(String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    private SortedSet<LocalizedMessage> _processContent(String fileName, String content, List<AbstractCheck> checks) throws IOException {
        FileText fileText = new FileText(new File(fileName), CheckstyleUtil.getLines(content));
        FileContents fileContents = new FileContents(fileText);
        try {
            DetailAST rootDetailAST = JavaParser.parse((FileContents)fileContents);
            return this._walk(rootDetailAST, fileContents, checks);
        }
        catch (CheckstyleException checkstyleException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)checkstyleException, checkstyleException);
            }
            return new TreeSet<LocalizedMessage>();
        }
    }

    private void _processFileContents(List<String[]> fileContents, List<AbstractCheck> checks) throws IOException {
        for (String[] fileContentArray : fileContents) {
            String content = fileContentArray[1];
            String fileName = fileContentArray[0];
            this.fireFileStarted(fileName);
            this.fireErrors(fileName, this._processContent(fileName, content, checks));
            this.fireFileFinished(fileName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SortedSet<LocalizedMessage> _walk(DetailAST rootDetailAST, FileContents fileContents, List<AbstractCheck> checks) {
        TreeSet<LocalizedMessage> messages = new TreeSet<LocalizedMessage>();
        for (AbstractCheck abstractCheck : checks) {
            abstractCheck.clearMessages();
            abstractCheck.setFileContents(fileContents);
            abstractCheck.beginTree(rootDetailAST);
        }
        DetailAST detailAST = rootDetailAST;
        while (detailAST != null) {
            void var6_10;
            for (AbstractCheck abstractCheck : checks) {
                if (!this._isRegisteredCheck(abstractCheck, detailAST.getType())) continue;
                abstractCheck.visitToken(detailAST);
            }
            DetailAST detailAST2 = detailAST.getFirstChild();
            while (detailAST != null && var6_10 == null) {
                for (AbstractCheck check2 : checks) {
                    if (!this._isRegisteredCheck(check2, detailAST.getType())) continue;
                    check2.leaveToken(detailAST);
                }
                DetailAST detailAST3 = detailAST.getNextSibling();
                detailAST = detailAST.getParent();
            }
            detailAST = var6_10;
        }
        for (AbstractCheck abstractCheck : checks) {
            abstractCheck.finishTree(rootDetailAST);
            messages.addAll(abstractCheck.getMessages());
        }
        return messages;
    }
}

