/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAssertEqualsCheck
extends BaseFileCheck {
    private static final Pattern _assertEqualsPattern = Pattern.compile("Assert\\.assertEquals\\((.*?)\\);\n", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("Test.java")) {
            content = this._formatAssertEquals(content);
        }
        return content;
    }

    private String _formatAssertEquals(String content) {
        Matcher matcher = _assertEqualsPattern.matcher(content);
        while (matcher.find()) {
            String parameters = StringUtil.trim(matcher.group(1));
            List<String> parametersList = JavaSourceUtil.splitParameters(parameters);
            if (parametersList.size() != 2) continue;
            String actualParameter = parametersList.get(1);
            String strippedQuotesActualParameter = this.stripQuotes(actualParameter);
            if (!actualParameter.startsWith("expected") && !Validator.isDigit(actualParameter) && Validator.isNotNull(strippedQuotesActualParameter)) continue;
            String assertEquals = matcher.group();
            String expectedParameter = parametersList.get(0);
            String newAssertEquals = StringUtil.replaceFirst(assertEquals, expectedParameter, actualParameter, assertEquals.indexOf(40));
            newAssertEquals = StringUtil.replaceLast(newAssertEquals, actualParameter, expectedParameter);
            return StringUtil.replace(content, assertEquals, newAssertEquals);
        }
        return content;
    }
}

