/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class JavaAPISignatureCheck
extends BaseJavaTermCheck {
    private static final String[] _CLASS_NAME_WHITELIST = new String[]{".*Action([A-Z].*)?", ".*Checker([A-Z].*)?", ".*Cookie([A-Z].*)?", ".*HTTP([A-Z].*)?", ".*Http([A-Z].*)?", ".*JSP([A-Z].*)?", ".*Language([A-Z].*)?", ".*Param([A-Z].*)?", ".*Portal([A-Z].*)?", ".*Portlet([A-Z].*)?", ".*Renderer([A-Z].*)?", ".*Request([A-Z].*)?", ".*Session([A-Z].*)?", ".*Template([A-Z].*)?", ".*Theme([A-Z].*)?", ".*URL([A-Z].*)?"};
    private static final String _ILLEGAL_API_PARAMETER_TYPES_KEY = "illegalAPIParameterTypes";
    private static final String _ILLEGAL_API_SERVICE_PARAMETER_TYPES_KEY = "illegalAPIServiceParameterTypes";
    private static final String[] _METHOD_NAME_WHITELIST = new String[]{".*JSP([A-Z].*)?", ".*PortletURL([A-Z].*)?", "include([A-Z].*)?", "render([A-Z].*)?"};
    private static final String[] _PACKAGE_NAME_WHITELIST = new String[]{".*\\.alloy\\.mvc(\\..*)?", ".*\\.auth(\\..*)?", ".*\\.axis(\\..*)?", ".*\\.display\\.context(\\..*)?", ".*\\.http(\\..*)?", ".*\\.jaxrs(\\..*)?", ".*\\.jsp(\\..*)?", ".*\\.layoutconfiguration\\.util(\\..*)?", ".*\\.portal\\.action(\\..*)?", ".*\\.portal\\.events(\\..*)?", ".*\\.portlet(\\..*)?", ".*\\.server\\.manager(\\..*)?", ".*\\.servlet(\\..*)?", ".*\\.spi\\.agent(\\..*)?", ".*\\.sso(\\..*)?", ".*\\.struts(\\..*)?", ".*\\.template(\\..*)?\\.internal(\\..*)?", ".*\\.taglib(\\..*)?", ".*\\.web(\\..*)?\\.internal(\\..*)?", ".*\\.web(\\..*)?\\.util(\\..*)?", ".*\\.webdav(\\..*)?", "com\\.liferay\\.frontend(\\..*)?", "com\\.liferay\\.portal\\.jsonwebservice(\\..*)?", "com\\.liferay\\.portal\\.language(\\..*)?", "com\\.liferay\\.portal\\.layoutconfiguration(\\..*)?"};
    private static final String[] _SERVICE_PACKAGE_NAME_WHITELIST = new String[]{".*\\.service(\\..*)?", ".*\\.test(\\..*)?"};
    private List<String> _allFileNames;
    private String[] _apiSignatureExceptions;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        if (!javaTerm.isPublic() || javaTerm.hasAnnotation("Override")) {
            return javaTerm.getContent();
        }
        String className = JavaSourceUtil.getClassName(fileName);
        String packageName = JavaSourceUtil.getPackageName(fileContent);
        JavaSignature signature = javaTerm.getSignature();
        if (this._isException(packageName, className, javaTerm.getName(), signature)) {
            return javaTerm.getContent();
        }
        List<String> illegalAPIParameterTypes = this.getAttributeValues(_ILLEGAL_API_PARAMETER_TYPES_KEY, absolutePath);
        List<String> illegalAPIServiceParameterTypes = this.getAttributeValues(_ILLEGAL_API_SERVICE_PARAMETER_TYPES_KEY, absolutePath);
        String methodName = javaTerm.getName();
        List<JavaParameter> parameters = signature.getParameters();
        for (JavaParameter parameter : parameters) {
            String parameterType = parameter.getParameterType();
            if (methodName.equals("set" + parameterType)) continue;
            if (illegalAPIServiceParameterTypes.contains(parameterType) && !absolutePath.contains("-service/") && !this._matches(_SERVICE_PACKAGE_NAME_WHITELIST, packageName)) {
                this.addMessage(fileName, "Do not use type '" + parameterType + "' in API method signature");
            }
            if (!illegalAPIParameterTypes.contains(parameterType) || this._matches(_CLASS_NAME_WHITELIST, className) || this._matches(_METHOD_NAME_WHITELIST, javaTerm.getName()) || this._matches(_PACKAGE_NAME_WHITELIST, packageName)) continue;
            this.addMessage(fileName, "Do not use type '" + parameterType + "' in API method signature");
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private synchronized String[] _getAPISignatureExceptions() throws IOException {
        if (this._apiSignatureExceptions != null) {
            return this._apiSignatureExceptions;
        }
        this._apiSignatureExceptions = new String[0];
        String fileName = "source-formatter-api-signature-check-exceptions.txt";
        List<String> exceptionFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/" + fileName}, this.getSourceFormatterExcludes(), true);
        for (String exceptionFileName : exceptionFileNames) {
            exceptionFileName = StringUtil.replace(exceptionFileName, '\\', '/');
            File file = new File(exceptionFileName);
            this._apiSignatureExceptions = ArrayUtil.append(this._apiSignatureExceptions, StringUtil.splitLines(FileUtil.read(file)));
        }
        for (int i = 0; i < 7; ++i) {
            File file = new File(this.getBaseDirName() + fileName);
            if (file.exists()) {
                this._apiSignatureExceptions = ArrayUtil.append(this._apiSignatureExceptions, StringUtil.splitLines(FileUtil.read(file)));
            }
            fileName = "../" + fileName;
        }
        return this._apiSignatureExceptions;
    }

    private boolean _isException(String packageName, String className, String methodName, JavaSignature javaSignature) throws IOException {
        StringBundler sb = new StringBundler(6);
        sb.append(packageName);
        sb.append('.');
        sb.append(className);
        sb.append('#');
        sb.append(methodName);
        sb.append(javaSignature.toString());
        return ArrayUtil.contains(this._getAPISignatureExceptions(), sb.toString());
    }

    private boolean _matches(String[] array, String s) {
        for (String arrayItem : array) {
            if (!s.matches(arrayItem)) continue;
            return true;
        }
        return false;
    }
}

