/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class AggregateResourceBundle
extends ResourceBundle {
    private volatile Set<String> _keys;
    private final ResourceBundle[] _resourceBundles;

    public AggregateResourceBundle(ResourceBundle ... resourceBundles) {
        this._resourceBundles = resourceBundles;
    }

    @Override
    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        for (ResourceBundle resourceBundle : this._resourceBundles) {
            if (!resourceBundle.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.handleKeySet());
    }

    @Override
    public Locale getLocale() {
        for (ResourceBundle resourceBundle : this._resourceBundles) {
            Locale locale = resourceBundle.getLocale();
            if (locale == null) continue;
            return locale;
        }
        return super.getLocale();
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        for (ResourceBundle resourceBundle : this._resourceBundles) {
            if (!resourceBundle.containsKey(key)) continue;
            try {
                return resourceBundle.getObject(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected Set<String> handleKeySet() {
        if (this._keys == null) {
            HashSet<String> keys = new HashSet<String>();
            for (ResourceBundle resourceBundle : this._resourceBundles) {
                keys.addAll(resourceBundle.keySet());
            }
            this._keys = keys;
        }
        return this._keys;
    }
}

