/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaMapBuilderGenericsCheck
extends BaseJavaTermCheck {
    private static final Log _log = LogFactoryUtil.getLog(JavaMapBuilderGenericsCheck.class);
    private static final Pattern _mapBuilderPattern = Pattern.compile(StringBundler.concat("((return|(\\w+) =)\\s*)?\\s(ConcurrentHash|Hash|LinkedHash|Tree)", "MapBuilder\\.\\s*(<([<>\\[\\],\\s\\.\\w\\?]+)>)?\\s*(put(All)?)", "\\("));

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        return this._formatGenerics(javaTerm, fileContent);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD, JAVA_VARIABLE};
    }

    private String _formatGenerics(JavaTerm javaTerm, String fileContent) {
        String content = javaTerm.getContent();
        Matcher matcher = _mapBuilderPattern.matcher(content);
        while (matcher.find()) {
            String[] genericTypesArray = null;
            String genericTypes = matcher.group(6);
            genericTypesArray = genericTypes != null ? this._getGenericTypesArray(genericTypes) : this._getGenericTypesArray(javaTerm, fileContent, matcher);
            if (genericTypesArray == null) continue;
            boolean requiresGenerics = false;
            String keyTypeName = genericTypesArray[0];
            String valueTypeName = genericTypesArray[1];
            if (keyTypeName.contains("<") || valueTypeName.contains("<")) {
                requiresGenerics = true;
            } else {
                Class<?> keyClazz = this._getClass(keyTypeName, javaTerm);
                Class<?> valueClazz = this._getClass(valueTypeName, javaTerm);
                if (this._requiresGenerics(keyClazz) || this._requiresGenerics(valueClazz)) {
                    requiresGenerics = true;
                } else if (keyClazz == null || valueClazz == null) continue;
            }
            if (!requiresGenerics && genericTypes != null) {
                return StringUtil.replaceFirst(content, matcher.group(5), "", matcher.start());
            }
            if (!requiresGenerics || genericTypes != null) continue;
            String methodName = matcher.group(7);
            return StringUtil.replaceFirst(content, methodName + "(", StringBundler.concat("<", keyTypeName, ", ", valueTypeName, ">", methodName, "("), matcher.end(4));
        }
        return content;
    }

    private Class<?> _getClass(String typeName, JavaTerm javaTerm) {
        typeName = StringUtil.removeChars(typeName, '[', ']');
        JavaClass javaClass = javaTerm.getParentJavaClass();
        while (javaClass.getParentJavaClass() != null) {
            javaClass = javaClass.getParentJavaClass();
        }
        for (String importName : javaClass.getImports()) {
            if (!importName.endsWith("." + typeName)) continue;
            try {
                return Class.forName(importName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(classNotFoundException, classNotFoundException);
            }
        }
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (_log.isDebugEnabled()) {
                _log.debug(classNotFoundException, classNotFoundException);
            }
            try {
                return Class.forName("java.lang." + typeName);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                if (_log.isDebugEnabled()) {
                    _log.debug(classNotFoundException2, classNotFoundException2);
                }
                try {
                    return Class.forName(javaClass.getPackageName() + "." + typeName);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(classNotFoundException3, classNotFoundException3);
                    }
                    return null;
                }
            }
        }
    }

    private String[] _getGenericTypesArray(JavaTerm javaTerm, String fileContent, Matcher matcher) {
        if (matcher.group(1) == null) {
            return null;
        }
        String mapTypeName = null;
        if (Objects.equals(matcher.group(2), "return")) {
            JavaSignature javaSignature = javaTerm.getSignature();
            mapTypeName = javaSignature.getReturnType();
        } else {
            mapTypeName = this.getVariableTypeName(javaTerm.getContent(), fileContent, matcher.group(3), true);
        }
        if (mapTypeName == null) {
            return null;
        }
        int x = mapTypeName.indexOf("<");
        if (x == -1) {
            return null;
        }
        return this._getGenericTypesArray(mapTypeName.substring(x + 1, mapTypeName.length() - 1));
    }

    private String[] _getGenericTypesArray(String genericTypes) {
        int x = -1;
        do {
            if ((x = genericTypes.indexOf(",", x + 1)) != -1) continue;
            return null;
        } while (this.getLevel(genericTypes.substring(0, x), "<", ">") != 0);
        return new String[]{StringUtil.trim(genericTypes.substring(0, x)), StringUtil.trim(genericTypes.substring(x + 1))};
    }

    private boolean _requiresGenerics(Class<?> clazz) {
        return clazz != null && (!Modifier.isFinal(clazz.getModifiers()) || !ArrayUtil.isEmpty(clazz.getTypeParameters()));
    }
}

