/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LanguageKeysCheck
extends BaseFileCheck {
    protected final Pattern languageKeyPattern = Pattern.compile("LanguageUtil.(?:get|format)\\([^;%]+|Liferay.Language.get\\('([^']+)");
    private static final Log _log = LogFactoryUtil.getLog(LanguageKeysCheck.class);
    private static final Pattern _applyLangMergerPluginPattern = Pattern.compile("^apply[ \t]+plugin[ \t]*:[ \t]+\"com.liferay.lang.merger\"$", 8);
    private static final Pattern _mergeLangPattern = Pattern.compile("mergeLang \\{.*sourceDirs = \\[(.*?)\\]", 32);
    private static final Pattern _metaAnnotationDescriptionParameterPattern = Pattern.compile("@Meta\\.(?:AD|OCD)\\([^\\{]*?description\\s*=\\s*\"(.+?)\"");
    private static final Pattern _metaAnnotationNameParameterPattern = Pattern.compile("@Meta\\.(?:AD|OCD)\\([^\\{]*?name\\s*=\\s*\"(.+?)\"");
    private Properties _portalLanguageProperties;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        this._checkLanguageKeys(fileName, absolutePath, content, this.getPatterns());
        return content;
    }

    protected List<Pattern> getPatterns() {
        return Arrays.asList(this.languageKeyPattern, _metaAnnotationDescriptionParameterPattern, _metaAnnotationNameParameterPattern);
    }

    private void _checkLanguageKeys(String fileName, String absolutePath, String content, List<Pattern> patterns) throws IOException {
        if (fileName.endsWith(".vm")) {
            return;
        }
        Properties portalLanguageProperties = this._getPortalLanguageProperties(absolutePath);
        if (portalLanguageProperties.isEmpty()) {
            return;
        }
        for (Pattern pattern : patterns) {
            this._checkLanguageKeys(fileName, absolutePath, content, portalLanguageProperties, pattern);
        }
    }

    private void _checkLanguageKeys(String fileName, String absolutePath, String content, Properties portalLanguageProperties, Pattern pattern) throws IOException {
        Matcher matcher = pattern.matcher(content);
        Properties buildGradleLanguageProperties = null;
        Properties langModuleLanguageProperties = null;
        Properties moduleLanguageProperties = null;
        while (matcher.find()) {
            String[] languageKeys;
            for (String languageKey : languageKeys = this._getLanguageKeys(matcher)) {
                Properties bndLanguageProperties;
                BNDSettings bndSettings;
                if (Validator.isNumber(languageKey) || languageKey.endsWith("}") || languageKey.endsWith("-") || languageKey.endsWith("[") || languageKey.endsWith(".") || languageKey.endsWith("_") || languageKey.startsWith("-") || languageKey.startsWith("$") || languageKey.startsWith("[") || languageKey.startsWith("{") || languageKey.startsWith(".") || languageKey.startsWith("_") || portalLanguageProperties.containsKey(languageKey)) continue;
                if (moduleLanguageProperties == null) {
                    moduleLanguageProperties = this._getModuleLanguageProperties(fileName);
                }
                if (moduleLanguageProperties.containsKey(languageKey)) continue;
                if (buildGradleLanguageProperties == null) {
                    buildGradleLanguageProperties = this._getBuildGradleLanguageProperties(absolutePath);
                }
                if (buildGradleLanguageProperties.containsKey(languageKey)) continue;
                if (langModuleLanguageProperties == null) {
                    langModuleLanguageProperties = this._getLangModuleLanguageProperties(absolutePath);
                }
                if (langModuleLanguageProperties.containsKey(languageKey) || (bndSettings = this.getBNDSettings(fileName)) != null && ((bndLanguageProperties = bndSettings.getLanguageProperties()) == null || bndLanguageProperties.containsKey(languageKey))) continue;
                this.addMessage(fileName, "Missing language key '" + languageKey + "'");
            }
        }
    }

    private Properties _getBuildGradleLanguageProperties(String absolutePath) throws IOException {
        File file;
        Properties properties = new Properties();
        String buildGradleContent = null;
        String buildGradleFileLocation = absolutePath;
        while (true) {
            int pos;
            if ((pos = buildGradleFileLocation.lastIndexOf("/")) == -1) {
                return properties;
            }
            file = new File((buildGradleFileLocation = buildGradleFileLocation.substring(0, pos + 1)) + "build.gradle");
            if (file.exists()) break;
            buildGradleFileLocation = StringUtil.replaceLast(buildGradleFileLocation, '/', "");
        }
        buildGradleContent = FileUtil.read(file);
        Matcher matcher = _applyLangMergerPluginPattern.matcher(buildGradleContent);
        if (!matcher.find()) {
            return properties;
        }
        String moduleLocation = StringUtil.replaceLast(buildGradleFileLocation, '/', "");
        List<String> moduleLangDirNames = this._getModuleLangDirNames(moduleLocation, buildGradleContent);
        for (String moduleLangDirName : moduleLangDirNames) {
            String moduleLangLanguagePropertiesFileName = moduleLangDirName + "/Language.properties";
            File file2 = new File(moduleLangLanguagePropertiesFileName);
            if (!file2.exists()) continue;
            FileInputStream inputStream = new FileInputStream(file2);
            properties.load(inputStream);
        }
        return properties;
    }

    private Properties _getLangModuleLanguageProperties(String absolutePath) throws IOException {
        Properties properties = new Properties();
        if (!this.isModulesFile(absolutePath)) {
            return properties;
        }
        ArrayList<String> langModulePaths = new ArrayList<String>();
        String fileLocation = absolutePath;
        int x = fileLocation.length();
        while ((x = fileLocation.lastIndexOf(47, x - 1)) != -1 && !(fileLocation = fileLocation.substring(0, x)).endsWith("/modules")) {
            File directory = new File(fileLocation);
            if (!directory.exists()) continue;
            for (File subdirectory : directory.listFiles(File::isDirectory)) {
                String subdirectoryPath = SourceUtil.getAbsolutePath(subdirectory);
                if (!subdirectoryPath.endsWith("-lang")) continue;
                langModulePaths.add(subdirectoryPath);
            }
            if (!this.isSubrepository() || !FileUtil.exists(fileLocation + "/gradle.properties")) continue;
            break;
        }
        for (String langModulePath : langModulePaths) {
            List<String> languagePropertyFileNames = SourceFormatterUtil.scanForFiles(langModulePath, new String[0], new String[]{"**/resources/content/Language.properties"}, new SourceFormatterExcludes(), true);
            if (languagePropertyFileNames.isEmpty()) continue;
            properties.load(new FileInputStream(new File(languagePropertyFileNames.get(0))));
        }
        if (absolutePath.contains("/modules/dxp/apps/")) {
            properties.putAll((Map<?, ?>)this._getLangModuleLanguageProperties(StringUtil.replace(absolutePath, "/modules/dxp/apps/", "/modules/apps/")));
        }
        return properties;
    }

    private String[] _getLanguageKeys(Matcher matcher) {
        int groupCount = matcher.groupCount();
        if (groupCount == 1) {
            String languageKey = matcher.group(1);
            if (Validator.isNotNull(languageKey)) {
                return new String[]{languageKey};
            }
        } else if (groupCount == 2) {
            String languageKey = matcher.group(2);
            languageKey = TextFormatter.format(languageKey, 10);
            return new String[]{languageKey};
        }
        StringBundler sb = new StringBundler();
        String match = matcher.group();
        int count = 0;
        for (int i = 0; i < match.length(); ++i) {
            char c = match.charAt(i);
            if (c == ')') {
                if (count <= 1) {
                    return new String[0];
                }
                --count;
                continue;
            }
            if (c == '(') {
                ++count;
                continue;
            }
            if (c != '\"' || count > 1) continue;
            while (i < match.length()) {
                if (match.charAt(++i) == '\"') {
                    String languageKey = sb.toString();
                    if (match.startsWith("names")) {
                        return StringUtil.split(languageKey);
                    }
                    return new String[]{languageKey};
                }
                sb.append(match.charAt(i));
            }
        }
        return new String[0];
    }

    private List<String> _getModuleLangDirNames(String moduleLocation, String buildGradleContent) {
        String projectLangDirName;
        File projectLangDir;
        String projectName;
        ArrayList<String> moduleLangDirNames = new ArrayList<String>();
        Matcher matcher = _mergeLangPattern.matcher(buildGradleContent);
        if (matcher.find()) {
            String[] sourceDirs;
            for (String sourceDir : sourceDirs = StringUtil.split(matcher.group(1))) {
                sourceDir = StringUtil.trim(sourceDir);
                moduleLangDirNames.add(moduleLocation + "/" + sourceDir.substring(1, sourceDir.length() - 1));
            }
            return moduleLangDirNames;
        }
        int x = moduleLocation.lastIndexOf("/");
        String baseModuleName = moduleLocation.substring(0, x);
        int y = baseModuleName.lastIndexOf("/");
        baseModuleName = baseModuleName.substring(y + 1);
        String moduleLangDirName = moduleLocation.substring(0, x + 1) + baseModuleName + "-lang/src/main/resources/content";
        File moduleLangDir = new File(moduleLangDirName);
        if (!moduleLangDir.exists() && moduleLangDirName.contains("/modules/ee/")) {
            moduleLangDirName = StringUtil.replaceFirst(moduleLangDirName, "/modules/ee/", "/modules/");
        }
        moduleLangDirNames.add(moduleLangDirName);
        if (moduleLangDirName.contains("/modules/dxp/apps/")) {
            moduleLangDirNames.add(StringUtil.replace(moduleLangDirName, "/modules/dxp/apps/", "/modules/apps/"));
        }
        if (Validator.isNotNull(projectName = this.getProjectName()) && (projectLangDir = new File(projectLangDirName = StringBundler.concat(moduleLocation.substring(0, x + 1), projectName, "-lang/src/main/resources/content"))).exists()) {
            moduleLangDirNames.add(projectLangDirName);
        }
        return moduleLangDirNames;
    }

    private Properties _getModuleLanguageProperties(String fileName) {
        Properties properties = new Properties();
        StringBundler sb = new StringBundler(3);
        int pos = fileName.indexOf("/docroot/");
        if (pos != -1) {
            sb.append(fileName.substring(0, pos + 9));
            sb.append("WEB-INF/src/");
        } else {
            pos = fileName.indexOf("src/");
            if (pos == -1) {
                return properties;
            }
            sb.append(fileName.substring(0, pos + 4));
            if (fileName.contains("src/main/")) {
                sb.append("main/resources/");
            }
        }
        sb.append("content/Language.properties");
        try {
            properties = new Properties();
            FileInputStream inputStream = new FileInputStream(sb.toString());
            properties.load(inputStream);
            return properties;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return properties;
        }
    }

    private synchronized Properties _getPortalLanguageProperties(String absolutePath) throws IOException {
        if (this._portalLanguageProperties != null) {
            return this._portalLanguageProperties;
        }
        this._portalLanguageProperties = new Properties();
        String portalLanguagePropertiesContent = this.getPortalContent("portal-impl/src/content/Language.properties", absolutePath);
        if (portalLanguagePropertiesContent == null) {
            return this._portalLanguageProperties;
        }
        this._portalLanguageProperties.load(new StringReader(portalLanguagePropertiesContent));
        return this._portalLanguageProperties;
    }
}

