/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStaticMethodCheck
extends BaseJavaTermCheck {
    private static final Pattern _superThisPattern = Pattern.compile("\\W(super|this)\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        int x;
        int x2;
        String content = javaTerm.getContent();
        JavaClass javaClass = javaTerm.getParentJavaClass();
        if (javaClass.isAnonymous()) {
            return content;
        }
        if (javaTerm.isStatic() && javaTerm.isFinal() && (x2 = content.indexOf("\t" + javaTerm.getAccessModifier())) != -1) {
            return StringUtil.replaceFirst(content, "final", "", x2);
        }
        String methodName = javaTerm.getName();
        Pattern pattern = Pattern.compile(StringBundler.concat("\\W", javaClass.getName(), "\\s*(\\.|::)\\s*", methodName, "\\W"));
        Matcher matcher = pattern.matcher(fileContent);
        if (matcher.find()) {
            return content;
        }
        if (javaTerm.isPrivate() && javaTerm.isStatic() && !this._staticRequired(javaTerm, Pattern.compile("(\\W|\\A)" + methodName + "(\\W|\\Z)")) && (x = content.indexOf("\t" + javaTerm.getAccessModifier())) != -1) {
            return StringUtil.replaceFirst(content, "static", "", x);
        }
        return content;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private boolean _staticRequired(JavaTerm javaTerm, Pattern pattern) {
        JavaClass javaClass = javaTerm.getParentJavaClass();
        if (javaClass == null) {
            return false;
        }
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            Matcher matcher1;
            if (childJavaTerm.isStatic() && childJavaTerm.getLineNumber() != javaTerm.getLineNumber() && (matcher1 = pattern.matcher(childJavaTerm.getContent())).find()) {
                return true;
            }
            if (!(childJavaTerm instanceof JavaConstructor)) continue;
            String content = childJavaTerm.getContent();
            Matcher matcher2 = _superThisPattern.matcher(childJavaTerm.getContent());
            while (matcher2.find()) {
                List<String> parameters = JavaSourceUtil.getParameterList(content.substring(matcher2.start()));
                for (String parameter : parameters) {
                    Matcher matcher3 = pattern.matcher(parameter);
                    if (!matcher3.find()) continue;
                    return true;
                }
            }
        }
        return this._staticRequired(javaClass, pattern);
    }
}

