/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;

public class CodeownersWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = super.doProcess(fileName, absolutePath, content);
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("#")) {
                    sb.append(line);
                } else {
                    String[] words = line.split("\\s+");
                    if (words.length == 1) {
                        sb.append(line);
                    } else {
                        sb.append(words[0]);
                        sb.append("    ");
                        for (int i = 1; i < words.length - 1; ++i) {
                            sb.append(words[i]);
                            sb.append(" ");
                        }
                        sb.append(words[words.length - 1]);
                    }
                }
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

