/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterCheckUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseSourceCheck
implements SourceCheck {
    protected static final String RUN_OUTSIDE_PORTAL_EXCLUDES = "run.outside.portal.excludes";
    private static final String _MODULES_PROPERTIES_FILE_NAME = "modules/modules.properties";
    private static final Log _log = LogFactoryUtil.getLog(BaseSourceCheck.class);
    private JSONObject _attributesJSONObject = new JSONObjectImpl();
    private final Map<String, String> _attributeValueMap = new ConcurrentHashMap<String, String>();
    private final Map<String, List<String>> _attributeValuesMap = new ConcurrentHashMap<String, List<String>>();
    private String _baseDirName;
    private final Map<String, BNDSettings> _bndSettingsMap = new ConcurrentHashMap<String, BNDSettings>();
    private JSONObject _excludesJSONObject;
    private final Map<String, List<String>> _excludesValuesMap = new ConcurrentHashMap<String, List<String>>();
    private List<String> _fileExtensions;
    private int _maxLineLength;
    private List<String> _pluginsInsideModulesDirectoryNames;
    private Document _portalCustomSQLDocument;
    private boolean _portalSource;
    private String _projectName;
    private String _projectPathPrefix;
    private SourceFormatterExcludes _sourceFormatterExcludes;
    private final Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();
    private boolean _subrepository;

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessages(String fileName) {
        if (this._sourceFormatterMessagesMap.containsKey(fileName)) {
            return this._sourceFormatterMessagesMap.get(fileName);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isEnabled(String absolutePath) {
        return this.isAttributeValue("enabled", absolutePath, true);
    }

    @Override
    public boolean isLiferaySourceCheck() {
        return false;
    }

    @Override
    public boolean isModuleSourceCheck() {
        return false;
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
    }

    @Override
    public void setAttributes(String attributes) throws JSONException {
        this._attributesJSONObject = new JSONObjectImpl(attributes);
    }

    @Override
    public void setBaseDirName(String baseDirName) {
        this._baseDirName = baseDirName;
    }

    @Override
    public void setExcludes(String excludes) throws JSONException {
        this._excludesJSONObject = new JSONObjectImpl(excludes);
    }

    @Override
    public void setFileExtensions(List<String> fileExtensions) {
        this._fileExtensions = fileExtensions;
    }

    @Override
    public void setMaxLineLength(int maxLineLength) {
        this._maxLineLength = maxLineLength;
    }

    @Override
    public void setPluginsInsideModulesDirectoryNames(List<String> pluginsInsideModulesDirectoryNames) {
        this._pluginsInsideModulesDirectoryNames = pluginsInsideModulesDirectoryNames;
    }

    @Override
    public void setPortalSource(boolean portalSource) {
        this._portalSource = portalSource;
    }

    @Override
    public void setProjectPathPrefix(String projectPathPrefix) {
        this._projectPathPrefix = projectPathPrefix;
    }

    @Override
    public void setSourceFormatterExcludes(SourceFormatterExcludes sourceFormatterExcludes) {
        this._sourceFormatterExcludes = sourceFormatterExcludes;
    }

    @Override
    public void setSubrepository(boolean subrepository) {
        this._subrepository = subrepository;
    }

    protected void addMessage(String fileName, String message) {
        this.addMessage(fileName, message, -1);
    }

    protected void addMessage(String fileName, String message, int lineNumber) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        Class<?> clazz = this.getClass();
        sourceFormatterMessages.add(new SourceFormatterMessage(fileName, message, CheckType.SOURCE_CHECK, clazz.getSimpleName(), SourceFormatterUtil.getDocumentationURLString(clazz), lineNumber));
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    protected void clearSourceFormatterMessages(String fileName) {
        this._sourceFormatterMessagesMap.remove(fileName);
    }

    protected String getAttributeValue(String attributeKey, String absolutePath) {
        return this.getAttributeValue(attributeKey, "", absolutePath);
    }

    protected String getAttributeValue(String attributeKey, String defaultValue, String absolutePath) {
        return SourceFormatterCheckUtil.getJSONObjectValue(this._attributesJSONObject, this._attributeValueMap, attributeKey, defaultValue, absolutePath, this._baseDirName);
    }

    protected List<String> getAttributeValues(String attributeKey, String absolutePath) {
        return SourceFormatterCheckUtil.getJSONObjectValues(this._attributesJSONObject, attributeKey, this._attributeValuesMap, absolutePath, this._baseDirName);
    }

    protected String getBaseDirName() {
        return this._baseDirName;
    }

    protected BNDSettings getBNDSettings(String fileName) throws IOException {
        String bndFileLocation = fileName;
        int pos;
        while ((pos = bndFileLocation.lastIndexOf("/")) != -1) {
            BNDSettings bndSettings = this._bndSettingsMap.get(bndFileLocation = bndFileLocation.substring(0, pos + 1));
            if (bndSettings != null) {
                return bndSettings;
            }
            File file = new File(bndFileLocation + "bnd.bnd");
            if (file.exists()) {
                bndSettings = new BNDSettings(bndFileLocation + "bnd.bnd", FileUtil.read(file));
                this._bndSettingsMap.put(bndFileLocation, bndSettings);
                return bndSettings;
            }
            bndFileLocation = StringUtil.replaceLast(bndFileLocation, '/', "");
        }
        return null;
    }

    protected String getBuildGradleContent(String absolutePath) throws IOException {
        String buildGradleFileName;
        File file;
        int x = absolutePath.length();
        do {
            if ((x = absolutePath.lastIndexOf("/", x - 1)) != -1) continue;
            return null;
        } while (!(file = new File(buildGradleFileName = absolutePath.substring(0, x + 1) + "build.gradle")).exists());
        return FileUtil.read(file);
    }

    protected String getContent(String fileName, int level) throws IOException {
        String content;
        File file = this.getFile(fileName, level);
        if (file != null && Validator.isNotNull(content = FileUtil.read(file))) {
            return content;
        }
        return "";
    }

    protected Document getCustomSQLDocument(String fileName, String absolutePath, Document portalCustomSQLDocument) throws DocumentException {
        if (this.isPortalSource() && !this.isModulesFile(absolutePath)) {
            return portalCustomSQLDocument;
        }
        int i = fileName.lastIndexOf("/src/");
        if (i == -1) {
            return null;
        }
        File customSQLFile = new File(fileName.substring(0, i) + "/src/custom-sql/default.xml");
        if (!customSQLFile.exists()) {
            customSQLFile = new File(fileName.substring(0, i) + "/src/main/resources/META-INF/custom-sql/default.xml");
        }
        if (!customSQLFile.exists()) {
            customSQLFile = new File(fileName.substring(0, i) + "/src/main/resources/custom-sql/default.xml");
        }
        if (!customSQLFile.exists()) {
            return null;
        }
        return SourceUtil.readXML(customSQLFile);
    }

    protected File getFile(String fileName, int level) {
        return SourceFormatterUtil.getFile(this._baseDirName, fileName, level);
    }

    protected List<String> getFileExtensions() {
        return this._fileExtensions;
    }

    protected List<String> getFileNames(String baseDirName, String[] excludes, String[] includes) throws IOException {
        return SourceFormatterUtil.scanForFiles(baseDirName, excludes, includes, this._sourceFormatterExcludes, true);
    }

    protected String getGitContent(String fileName, String branchName) {
        return SourceFormatterUtil.getGitContent(fileName, branchName);
    }

    protected int getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    protected int getLevel(String s) {
        return ToolsUtil.getLevel(s);
    }

    protected int getLevel(String s, String increaseLevelString, String decreaseLevelString) {
        return ToolsUtil.getLevel(s, increaseLevelString, decreaseLevelString);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings) {
        return ToolsUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings, int startLevel) {
        return ToolsUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings, startLevel);
    }

    protected String getLine(String content, int lineNumber) {
        return SourceUtil.getLine(content, lineNumber);
    }

    protected int getLineNumber(String content, int pos) {
        return SourceUtil.getLineNumber(content, pos);
    }

    protected int getLineStartPos(String content, int lineNumber) {
        return SourceUtil.getLineStartPos(content, lineNumber);
    }

    protected int getMaxLineLength() {
        return this._maxLineLength;
    }

    protected String getModulesPropertiesContent(String absolutePath) throws IOException {
        if (!this.isPortalSource()) {
            return this.getPortalContent(_MODULES_PROPERTIES_FILE_NAME, absolutePath);
        }
        return this.getContent(_MODULES_PROPERTIES_FILE_NAME, 7);
    }

    protected List<String> getPluginsInsideModulesDirectoryNames() {
        return this._pluginsInsideModulesDirectoryNames;
    }

    protected String getPortalContent(String fileName, String absolutePath) throws IOException {
        return this.getPortalContent(fileName, absolutePath, false);
    }

    protected String getPortalContent(String fileName, String absolutePath, boolean forceRetrieveFromGit) throws IOException {
        String portalBranchName = this.getAttributeValue("git.liferay.portal.branch", absolutePath);
        if (forceRetrieveFromGit) {
            return this.getGitContent(fileName, portalBranchName);
        }
        String content = this.getContent(fileName, 7);
        if (Validator.isNotNull(content)) {
            return content;
        }
        return this.getGitContent(fileName, portalBranchName);
    }

    protected synchronized Document getPortalCustomSQLDocument(String absolutePath) throws DocumentException, IOException {
        if (this._portalCustomSQLDocument != null) {
            return this._portalCustomSQLDocument;
        }
        this._portalCustomSQLDocument = DocumentHelper.createDocument();
        if (!this.isPortalSource()) {
            return this._portalCustomSQLDocument;
        }
        String portalCustomSQLDefaultContent = this.getPortalContent("portal-impl/src/custom-sql/default.xml", absolutePath);
        if (portalCustomSQLDefaultContent == null) {
            return this._portalCustomSQLDocument;
        }
        Element rootElement = this._portalCustomSQLDocument.addElement("custom-sql");
        Document customSQLDefaultDocument = SourceUtil.readXML(portalCustomSQLDefaultContent);
        Element customSQLDefaultRootElement = customSQLDefaultDocument.getRootElement();
        for (Element sqlElement : customSQLDefaultRootElement.elements("sql")) {
            String customSQLFileContent = this.getPortalContent("portal-impl/src/" + sqlElement.attributeValue("file"), absolutePath);
            if (customSQLFileContent == null) continue;
            Document customSQLDocument = SourceUtil.readXML(customSQLFileContent);
            Element customSQLRootElement = customSQLDocument.getRootElement();
            for (Element customSQLElement : customSQLRootElement.elements("sql")) {
                rootElement.add(customSQLElement.detach());
            }
        }
        return this._portalCustomSQLDocument;
    }

    protected File getPortalDir() {
        File portalImplDir = SourceFormatterUtil.getFile(this.getBaseDirName(), "portal-impl", 7);
        if (portalImplDir == null) {
            return null;
        }
        return portalImplDir.getParentFile();
    }

    protected InputStream getPortalInputStream(String fileName, String absolutePath) throws IOException {
        File file = this.getFile(fileName, 7);
        if (file != null) {
            return new FileInputStream(file);
        }
        String portalBranchName = this.getAttributeValue("git.liferay.portal.branch", absolutePath);
        URL url = SourceFormatterUtil.getPortalGitURL(fileName, portalBranchName);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    protected String getProjectName() {
        if (this._projectName != null) {
            return this._projectName;
        }
        if (Validator.isNull(this._projectPathPrefix) || !this._projectPathPrefix.contains(":")) {
            this._projectName = "";
            return this._projectName;
        }
        int pos = this._projectPathPrefix.lastIndexOf(":");
        this._projectName = this._projectPathPrefix.substring(pos + 1);
        return this._projectName;
    }

    protected String getProjectPathPrefix() {
        return this._projectPathPrefix;
    }

    protected SourceFormatterExcludes getSourceFormatterExcludes() {
        return this._sourceFormatterExcludes;
    }

    protected String getVariableTypeName(String content, String fileContent, String variableName) {
        return this.getVariableTypeName(content, fileContent, variableName, false);
    }

    protected String getVariableTypeName(String content, String fileContent, String variableName, boolean includeArrayOrCollectionTypes) {
        if (variableName == null) {
            return null;
        }
        String variableTypeName = this._getVariableTypeName(content, variableName, includeArrayOrCollectionTypes);
        if (variableTypeName != null || content.equals(fileContent)) {
            return variableTypeName;
        }
        return this._getVariableTypeName(fileContent, variableName, includeArrayOrCollectionTypes);
    }

    protected boolean isAttributeValue(String attributeKey, String absolutePath) {
        return GetterUtil.getBoolean(this.getAttributeValue(attributeKey, absolutePath));
    }

    protected boolean isAttributeValue(String attributeKey, String absolutePath, boolean defaultValue) {
        String attributeValue = this.getAttributeValue(attributeKey, absolutePath);
        if (Validator.isNull(attributeValue)) {
            return defaultValue;
        }
        return GetterUtil.getBoolean(attributeValue);
    }

    protected boolean isExcludedPath(String key, String path) {
        return this.isExcludedPath(key, path, -1);
    }

    protected boolean isExcludedPath(String key, String path, int lineNumber) {
        return SourceFormatterCheckUtil.isExcludedPath(this._excludesJSONObject, this._excludesValuesMap, key, path, lineNumber, null, this._baseDirName);
    }

    protected boolean isExcludedPath(String key, String path, String parameter) {
        return SourceFormatterCheckUtil.isExcludedPath(this._excludesJSONObject, this._excludesValuesMap, key, path, -1, parameter, this._baseDirName);
    }

    protected boolean isModulesApp(String absolutePath, boolean privateOnly) {
        if (absolutePath.contains("/modules/dxp/apps") || absolutePath.contains("/modules/private/apps/") || !privateOnly && absolutePath.contains("/modules/apps/")) {
            return true;
        }
        if (this._projectPathPrefix == null) {
            return false;
        }
        return this._projectPathPrefix.startsWith(":private:apps") || this._projectPathPrefix.startsWith(":dxp:apps") || !privateOnly && this._projectPathPrefix.startsWith(":apps:");
    }

    protected boolean isModulesFile(String absolutePath) {
        return this.isModulesFile(absolutePath, null);
    }

    protected boolean isModulesFile(String absolutePath, List<String> pluginsInsideModulesDirectoryNames) {
        block5: {
            if (this._subrepository) {
                return true;
            }
            if (pluginsInsideModulesDirectoryNames == null) {
                return absolutePath.contains("/modules/");
            }
            try {
                for (String directoryName : pluginsInsideModulesDirectoryNames) {
                    if (!absolutePath.contains(directoryName)) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug(exception, exception);
            }
        }
        return absolutePath.contains("/modules/");
    }

    protected boolean isPortalSource() {
        return this._portalSource;
    }

    protected boolean isSubrepository() {
        return this._subrepository;
    }

    protected String stripQuotes(String s) {
        return this.stripQuotes(s, '\'', '\"');
    }

    protected String stripQuotes(String s, char ... delimeters) {
        List<Character> delimetersList = ListUtil.fromArray(delimeters);
        char delimeter = ' ';
        boolean insideQuotes = false;
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (insideQuotes) {
                if (c != delimeter) continue;
                int precedingBackSlashCount = 0;
                for (int j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                    ++precedingBackSlashCount;
                }
                if (precedingBackSlashCount != 0 && precedingBackSlashCount % 2 != 0) continue;
                insideQuotes = false;
                continue;
            }
            if (delimetersList.contains(Character.valueOf(c))) {
                delimeter = c;
                insideQuotes = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String _getVariableTypeName(String content, String variableName, boolean includeArrayOrCollectionTypes) {
        Pattern pattern = Pattern.compile("\\W(\\w+)\\s+" + variableName + "\\s*[;=),]");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (!includeArrayOrCollectionTypes) {
            return null;
        }
        pattern = Pattern.compile("[\\]>]\\s+" + variableName + "\\s*[;=),]");
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        int i = matcher.start() + 1;
        for (int j = i - 2; j > 0; --j) {
            String typeName;
            if (Character.isLetterOrDigit(content.charAt(j)) || !Character.isLetterOrDigit(content.charAt(j + 1)) || this.getLevel(typeName = content.substring(j + 1, i), "<", ">") != 0 || this.getLevel(typeName, "[", "]") != 0) continue;
            return typeName;
        }
        return null;
    }
}

