/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseEmptyLinesCheck
extends BaseFileCheck {
    private static final String[] _STYLING_TAG_NAMES = new String[]{"dd", "dt", "li", "span", "td", "th", "tr"};
    private static final Pattern _emptyLineBetweenTagsPattern1 = Pattern.compile("\n(\t*)</([-\\w:]+)>(\n*)(\t*)<([-\\w:]+)[> \n]");
    private static final Pattern _emptyLineBetweenTagsPattern2 = Pattern.compile("(\\S</(\\w+)>| />)\n(\t+)<([-\\w:]+)[> \n]");
    private static final Pattern _emptyLineInMultiLineTagsPattern1 = Pattern.compile("\n\t*<[-\\w:#]+\n\n\t*\\w");
    private static final Pattern _emptyLineInMultiLineTagsPattern2 = Pattern.compile("\n(\t*)\\S*[^>]\n\n(\t*)(/?)>\n");
    private static final Pattern _emptyLineInNestedTagsPattern1 = Pattern.compile("\n(\t*)(?:<\\w.*[^/])?>\n(?=\n(\t*)(<.*)\n)");
    private static final Pattern _emptyLineInNestedTagsPattern2 = Pattern.compile("\n(\t*)(.*>)\n(?=\n(\t*)</.*(\n|$))");
    private static final Pattern _incorrectCloseCurlyBracePattern1 = Pattern.compile("\n(.+)\n\n(\t+)}\n");
    private static final Pattern _incorrectCloseCurlyBracePattern2 = Pattern.compile("(\t| )@?(class|enum|interface|new)\\s");
    private static final Pattern _incorrectCloseCurlyBracePattern3 = Pattern.compile("\n\t*\\}(\n+)\t*\\}\\)*;\n");
    private static final Pattern _incorrectOpenCurlyBracePattern = Pattern.compile("\n.*?(\\Wnew (.*\\)) |\\[\\] (\\w+ = )?)?\\{(\n+)\t*\\{\n");
    private static final Pattern _missingEmptyLineAfterCommentPattern = Pattern.compile("\n\t*// .*\n[\t ]*(?!// )\\S");
    private static final Pattern _missingEmptyLineAfterDoctypePattern = Pattern.compile("^(<\\?xml .*\\?>|<\\!DOCTYPE .*>)\n<\\w", 10);
    private static final Pattern _missingEmptyLineBeforeCommentPattern = Pattern.compile("\n[\t ]*(?!// )\\S.*\n\t*// ");
    private static final Pattern _missingEmptyLineBetweenTagsPattern1 = Pattern.compile("\n(\t*)/>\n(\t*)<[-\\w:]+[> \n]");
    private static final Pattern _missingEmptyLineBetweenTagsPattern2 = Pattern.compile("\n(\t*)<.* />\n(\t*)<([-\\w:]+|\\w((?!</| />).)*[^/]>)\n");
    private static final Pattern _missingEmptyLinePattern1 = Pattern.compile("(\t| = | -> |return )new .*\\(.*\\) \\{\n\t+[^{\t]");
    private static final Pattern _missingEmptyLinePattern2 = Pattern.compile("(\n\t*)(public|private|protected) [^;]+? \\{");
    private static final Pattern _missingEmptyLinePattern3 = Pattern.compile("\n(.*\\) \\{)\n[\t ]*[^ \n\t\\}]");
    private static final Pattern _missingEmptyLinePattern4 = Pattern.compile("[^%{:/\n]\n\t*(for|if|try) [({]");
    private static final Pattern _missingEmptyLinePattern5 = Pattern.compile("[\t\n]\\}\n[\t ]*(?!(%>|/?\\*|\\}|\\)|//|catch |else |finally |while ))\\S");
    private static final Pattern _missingEmptyLinePattern6 = Pattern.compile("[^%{:\\s]\n\t*(break|continue|return|throw)[ ;]");
    private static final Pattern _missingEmptyLinePattern7 = Pattern.compile("[^%{\\s]\n\t*break;");
    private static final Pattern _redundantEmptyLinePattern1 = Pattern.compile("\n(.*)\n\npublic ((abstract|static) )*(class|enum|interface) ");
    private static final Pattern _redundantEmptyLinePattern2 = Pattern.compile("\n\t* \\*/\n\n\t*(.+)\n");
    private static final Pattern _redundantEmptyLinePattern3 = Pattern.compile("[\n\t](catch |else |finally |for |if |try |while ).*\\{\n\n\t+\\w");
    private static final Pattern _redundantEmptyLinePattern4 = Pattern.compile("\\{\n\n\t*\\}");
    private static final Pattern _redundantEmptyLinePattern5 = Pattern.compile("\\}\n\n\t*(catch|else( if)?|finally) [\\(\\{]");
    private static final Pattern _setVariablePattern = Pattern.compile("(?<=[\n\t])[A-Z]\\w+(<[^\n]+>)? (\\w+) =\\s+((?!\\{\n).)*?;\n", 32);

    protected String fixEmptyLinesBetweenTags(String content) {
        String tabs2;
        Matcher matcher = _emptyLineBetweenTagsPattern1.matcher(content);
        while (matcher.find()) {
            String tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(4))) continue;
            String lineBreaks = matcher.group(3);
            String tagName1 = matcher.group(2);
            String tagName2 = matcher.group(5);
            if (tagName1.endsWith(":when") || ArrayUtil.contains(_STYLING_TAG_NAMES, tagName1) && ArrayUtil.contains(_STYLING_TAG_NAMES, tagName2)) {
                if (!lineBreaks.equals("\n\n")) continue;
                return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.end(1));
            }
            if (!lineBreaks.equals("\n")) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        matcher = _emptyLineBetweenTagsPattern2.matcher(content);
        while (matcher.find()) {
            String tagName2;
            String trimmedLine;
            int lineNumber = this.getLineNumber(content, matcher.start());
            String line = this.getLine(content, lineNumber);
            String tabs = SourceUtil.getIndent(line);
            if (!tabs.equals(matcher.group(3)) || !(trimmedLine = StringUtil.trimLeading(line)).startsWith("<") || line.contains("\"hidden\"") || (line = this.getLine(content, lineNumber + 1)).contains("\"hidden\"")) continue;
            String tagName1 = matcher.group(2);
            if (tagName1 == null) {
                int pos = trimmedLine.indexOf(32);
                tagName1 = trimmedLine.substring(1, pos);
            }
            if (tagName1.equals(tagName2 = matcher.group(4)) || ArrayUtil.contains(_STYLING_TAG_NAMES, tagName1) && ArrayUtil.contains(_STYLING_TAG_NAMES, tagName2)) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = _missingEmptyLineBetweenTagsPattern1.matcher(content);
        while (matcher.find()) {
            String tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(2))) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        matcher = _missingEmptyLineBetweenTagsPattern2.matcher(content);
        while (matcher.find()) {
            String tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(2))) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        return content;
    }

    protected String fixEmptyLinesInMultiLineTags(String content) {
        Matcher matcher = _emptyLineInMultiLineTagsPattern1.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        matcher = _emptyLineInMultiLineTagsPattern2.matcher(content);
        while (matcher.find()) {
            String tabs1 = matcher.group(1);
            String tabs2 = matcher.group(2);
            if (tabs1.length() != tabs2.length() + 1) continue;
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }

    protected String fixEmptyLinesInNestedTags(String content) {
        content = this.fixEmptyLinesInNestedTags(content, _emptyLineInNestedTagsPattern1, true);
        return this.fixEmptyLinesInNestedTags(content, _emptyLineInNestedTagsPattern2, false);
    }

    protected String fixEmptyLinesInNestedTags(String content, Pattern pattern, boolean startTag) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String tabs2 = null;
            if (startTag) {
                String secondLine = matcher.group(3);
                if (secondLine.equals("<%") || secondLine.startsWith("<%--") || secondLine.startsWith("<!--")) continue;
                tabs2 = matcher.group(2);
            } else {
                String firstLine = matcher.group(2);
                if (firstLine.equals("%>") || firstLine.endsWith("-->")) continue;
                tabs2 = matcher.group(3);
            }
            String tabs1 = matcher.group(1);
            if ((!startTag || tabs1.length() + 1 != tabs2.length()) && (startTag || tabs1.length() - 1 != tabs2.length())) continue;
            content = StringUtil.replaceFirst(content, "\n", "", matcher.end(1));
        }
        return content;
    }

    protected String fixIncorrectEmptyLineAfterOpenCurlyBrace(String content) {
        Matcher matcher = _incorrectOpenCurlyBracePattern.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.end())) continue;
            boolean requiresEmptyLine = false;
            String s = matcher.group(2);
            if (s != null) {
                if (this.getLevel(s) != 0) continue;
                int x = this._getMatchingClosingCurlyBracePos(content, matcher.end() - 2);
                s = StringUtil.trim(content.substring(x + 1));
                if (!s.startsWith("}")) {
                    requiresEmptyLine = true;
                }
            } else if (matcher.group(1) == null) {
                requiresEmptyLine = true;
            }
            String lineBreaks = matcher.group(4);
            if (requiresEmptyLine && lineBreaks.equals("\n")) {
                return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start(4));
            }
            if (requiresEmptyLine || !lineBreaks.equals("\n\n")) continue;
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start(4));
        }
        return content;
    }

    protected String fixIncorrectEmptyLineBeforeCloseCurlyBrace(String content) {
        Matcher matcher1 = _incorrectCloseCurlyBracePattern1.matcher(content);
        while (matcher1.find()) {
            char c;
            String lastLine;
            if (!this.isJavaSource(content, matcher1.end()) || (lastLine = StringUtil.trimLeading(matcher1.group(1))).startsWith("// ")) continue;
            String tabs = matcher1.group(2);
            int tabCount = tabs.length();
            int pos = matcher1.start();
            while ((c = content.charAt((pos = content.lastIndexOf("\n" + tabs, pos - 1)) + tabCount + 1)) == '\n' || c == '\t') {
            }
            String codeBlock = content.substring(pos + 1, matcher1.end());
            String firstLine = codeBlock.substring(0, codeBlock.indexOf(10) + 1);
            Matcher matcher2 = _incorrectCloseCurlyBracePattern2.matcher(firstLine);
            if (matcher2.find()) continue;
            return StringUtil.replaceFirst(content, "\n\n" + tabs + "}\n", "\n" + tabs + "}\n", pos);
        }
        matcher1 = _incorrectCloseCurlyBracePattern3.matcher(content);
        while (matcher1.find()) {
            if (!this.isJavaSource(content, matcher1.end())) continue;
            String lineBreaks = matcher1.group(1);
            int x = this._getMatchingOpenCurlyBracePos(content, matcher1.end());
            int lineNumber = this.getLineNumber(content, x);
            String lineAfterOpenCurlyBrace = this.getLine(content, lineNumber + 1);
            if (Validator.isNull(lineAfterOpenCurlyBrace) && lineBreaks.equals("\n")) {
                String nextLineAfterOpenCurlyBrace = StringUtil.trim(this.getLine(content, lineNumber + 2));
                if (nextLineAfterOpenCurlyBrace.startsWith("//")) continue;
                return StringUtil.replaceFirst(content, "\n", "\n\n", matcher1.start(1));
            }
            if (!Validator.isNotNull(lineAfterOpenCurlyBrace) || !lineBreaks.equals("\n\n")) continue;
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher1.start(1));
        }
        return content;
    }

    protected String fixMissingEmptyLineAfterDoctype(String content) {
        Matcher matcher = _missingEmptyLineAfterDoctypePattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        return content;
    }

    protected String fixMissingEmptyLineAfterSettingVariable(String content) {
        Matcher matcher1 = _setVariablePattern.matcher(content);
        while (matcher1.find()) {
            int z;
            int y;
            if (!this.isJavaSource(content, matcher1.start()) || content.charAt(matcher1.end()) == '\n') continue;
            int x = content.indexOf(";\n", matcher1.end());
            if (x == -1) {
                return content;
            }
            String nextCommand = content.substring(matcher1.end(), x + 1);
            if (nextCommand.contains("{\n") || nextCommand.matches("\t*%>[\\S\\s]*")) continue;
            String variableName = matcher1.group(2);
            Pattern pattern2 = Pattern.compile("\\W(" + variableName + ")\\W");
            Matcher matcher2 = pattern2.matcher(nextCommand);
            if (!matcher2.find() || ToolsUtil.isInsideQuotes(nextCommand, x = matcher2.start(1)) || (y = content.lastIndexOf("\ttry (", x += matcher1.end())) != -1 && (z = content.indexOf(") {\n", y)) > x) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher1.end(3));
        }
        return content;
    }

    protected String fixMissingEmptyLines(String absolutePath, String content) {
        Matcher matcher = _missingEmptyLinePattern1.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start()) || this.getLevel(matcher.group()) != 0) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = _missingEmptyLinePattern2.matcher(content);
        while (matcher.find()) {
            String match;
            if (!this.isJavaSource(content, matcher.start()) || !(match = matcher.group()).contains("(")) continue;
            String whitespace = matcher.group(1);
            int x = content.indexOf(whitespace + "}\n", matcher.end());
            int y = content.indexOf(whitespace + "}\n\n", matcher.end());
            if (x == -1 || x == y) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", x + 1);
        }
        matcher = _missingEmptyLinePattern3.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start()) || this.getLevel(matcher.group(1)) == 0) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        matcher = _missingEmptyLinePattern4.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = _missingEmptyLinePattern5.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
        }
        matcher = _missingEmptyLinePattern6.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = _missingEmptyLinePattern7.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        return content;
    }

    protected String fixMissingEmptyLinesAroundComments(String content) {
        Matcher matcher = _missingEmptyLineAfterCommentPattern.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
        }
        matcher = _missingEmptyLineBeforeCommentPattern.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
        }
        return content;
    }

    protected String fixRedundantEmptyLines(String content) {
        block0: while (true) {
            Matcher matcher = _redundantEmptyLinePattern1.matcher(content);
            while (matcher.find()) {
                String previousLine;
                if (!this.isJavaSource(content, matcher.start()) || (previousLine = StringUtil.trim(matcher.group(1))).startsWith("import ") || previousLine.startsWith("package ")) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.end(1));
                continue block0;
            }
            matcher = _redundantEmptyLinePattern2.matcher(content);
            while (matcher.find()) {
                String nextLine;
                if (!this.isJavaSource(content, matcher.start()) || (nextLine = matcher.group(1)).startsWith("import ") || nextLine.startsWith("package ") || nextLine.startsWith("/*")) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start() + 1);
                continue block0;
            }
            matcher = _redundantEmptyLinePattern3.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start() + 1);
                continue block0;
            }
            matcher = _redundantEmptyLinePattern4.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start());
                continue block0;
            }
            matcher = _redundantEmptyLinePattern5.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start());
                continue block0;
            }
            break;
        }
        return content;
    }

    protected boolean isJavaSource(String content, int pos) {
        return true;
    }

    private int _getMatchingClosingCurlyBracePos(String content, int start) {
        int x = start;
        while (this.getLevel(content.substring(start, (x = content.indexOf(125, x + 1)) + 1), "{", "}") != 0) {
        }
        return x;
    }

    private int _getMatchingOpenCurlyBracePos(String content, int start) {
        int y;
        String s;
        int x = start;
        while ((s = StringUtil.trim(content.substring(y = content.lastIndexOf("\n", (x = content.lastIndexOf(123, x - 1)) - 1), x))).startsWith("//") || s.startsWith("*") || this.getLevel(content.substring(x, start), "{", "}") != 0) {
        }
        return x;
    }
}

