/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.BaseImportsFormatter;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.source.formatter.BNDImportPackage;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDImportsFormatter
extends BaseImportsFormatter {
    public static String getImports(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(3);
        }
        return null;
    }

    @Override
    protected ImportPackage createImportPackage(String line) {
        String importString;
        if (line.endsWith("\\")) {
            line = line.substring(0, line.length() - 1);
        }
        if (line.endsWith(",")) {
            line = line.substring(0, line.length() - 1);
        }
        if (Validator.isNull(importString = StringUtil.trim(line))) {
            return null;
        }
        int pos = importString.indexOf(";");
        if (pos != -1) {
            importString = importString.substring(0, pos);
        }
        return new BNDImportPackage(importString, line);
    }

    @Override
    protected String doFormat(String content, Pattern importPattern, String packageDir, String className) throws IOException {
        String imports = BNDImportsFormatter.getImports(content, importPattern);
        if (Validator.isNull(imports)) {
            return content;
        }
        String newImports = this.sortAndGroupImports(imports);
        newImports = newImports.substring(0, newImports.length() - 1);
        if (!imports.equals(newImports = StringUtil.replace(newImports, new String[]{"\n", "\n,\\"}, new String[]{",\\\n", "\n\t\\"}))) {
            content = StringUtil.replaceFirst(content, imports, newImports);
        }
        return content;
    }
}

