/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleStylingCheck
extends BaseFileCheck {
    private static final Pattern _mapKeyPattern = Pattern.compile("(\".+?\") *: *(\".+?\")");
    private static final Pattern _multiLineStringsPattern = Pattern.compile("(\"\"\"|''')\\\\\n.*?\\1", 32);
    private static final Pattern _stylingPattern1 = Pattern.compile("(\\A|\n)(\\w+)\\.(\\w+ = \\w+)(\n|\\Z)");
    private static final Pattern _stylingPattern2 = Pattern.compile("(\\A|\n)(\t*\\w+)(?! = .) *=(?!~) *(.*?)(\n|\\Z)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._sortMapKeys("transformKeys", content);
        content = this._stylingCheck(content, _stylingPattern1, "$1$2 {\n\t$3\n}$4");
        content = this._stylingCheck(content, _stylingPattern2, "$1$2 = $3$4");
        return content;
    }

    private String _sortMapKeys(String mapName, String content) {
        Pattern pattern = Pattern.compile("\n(\t*)(" + mapName + ") = \\[([\\s\\S]*?)\\]\n");
        Matcher matcher1 = pattern.matcher(content);
        if (!matcher1.find()) {
            return content;
        }
        String match = matcher1.group(3);
        if (Validator.isNull(match)) {
            return content;
        }
        TreeMap<String, String> map = new TreeMap<String, String>(new NaturalOrderStringComparator());
        Matcher matcher2 = _mapKeyPattern.matcher(match);
        while (matcher2.find()) {
            map.put(matcher2.group(1), matcher2.group(2));
        }
        StringBundler sb = new StringBundler(map.size() * 9);
        String indent = matcher1.group(1);
        for (Map.Entry entry : map.entrySet()) {
            if (map.size() == 1) {
                sb.append((String)entry.getKey());
                sb.append(": ");
                sb.append((String)entry.getValue());
                break;
            }
            sb.append('\n');
            sb.append(indent);
            sb.append('\t');
            sb.append((String)entry.getKey());
            sb.append(": ");
            sb.append((String)entry.getValue());
            sb.append(',');
        }
        if (map.size() > 1) {
            sb.setIndex(sb.index() - 1);
            sb.append('\n');
            sb.append(indent);
        }
        return StringUtil.replaceFirst(content, match, sb.toString());
    }

    private String _stylingCheck(String content, Pattern pattern, String replacement) {
        int[] multiLineStringsPositions = SourceUtil.getMultiLinePositions(content, _multiLineStringsPattern);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (SourceUtil.isInsideMultiLines(SourceUtil.getLineNumber(content, matcher.start()), multiLineStringsPositions)) continue;
            return matcher.replaceFirst(replacement);
        }
        return content;
    }
}

