/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.FileInputStream;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CollatorUtil {
    private static final Log _log = LogFactoryUtil.getLog(CollatorUtil.class);
    private static final Map<Locale, String> _rules = new ConcurrentHashMap<Locale, String>();

    public static Collator getInstance(Locale locale) {
        String rules = _rules.get(locale);
        if (rules == null) {
            String languageId = LocaleUtil.toLanguageId(locale);
            rules = PropsUtil.get("collator.rules", new Filter(languageId));
            if (Validator.isNull(rules)) {
                rules = "";
            } else if (rules.startsWith("file:")) {
                try (FileInputStream is = new FileInputStream(rules.substring(5));){
                    rules = StringUtil.read(is);
                }
                catch (Exception exception) {
                    _log.error(exception, exception);
                    rules = "";
                }
            }
            _rules.put(locale, rules);
        }
        if (!rules.equals("")) {
            try {
                return new RuleBasedCollator(rules);
            }
            catch (ParseException parseException) {
                _log.error(parseException, parseException);
                _rules.put(locale, "");
            }
        }
        return Collator.getInstance(locale);
    }
}

