/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public abstract class BaseStringConcatenationCheck
extends BaseCheck {
    protected static final String MSG_COMBINE_LITERAL_STRINGS = "literal.string.combine";
    protected static final String MSG_INCORRECT_PLUS = "plus.incorrect";
    protected static final String MSG_MOVE_LITERAL_STRING = "literal.string.move";
    private static final String _MSG_COMBINE_STRING = "string.combine";
    private static final String _MSG_INVALID_END_CHARACTER = "end.character.invalid";
    private static final String _MSG_INVALID_START_CHARACTER = "start.character.invalid";

    protected void checkCombineOperand(DetailAST literalStringDetailAST, DetailAST operandDetailAST) {
        if (operandDetailAST.getType() != 59) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)operandDetailAST);
        String text = fullIdent.getText();
        if (!(!text.startsWith("CharPool.") && !text.startsWith("StringPool.") || text.endsWith(".NEW_LINE") || text.endsWith(".NO_BREAK_SPACE") || text.endsWith(".TAB"))) {
            this.log(literalStringDetailAST, _MSG_COMBINE_STRING, new Object[]{this.getStringValue(literalStringDetailAST), text});
        }
    }

    protected void checkLiteralStringStartAndEndCharacter(String literalString1, String literalString2, int lineNumber) {
        if (literalString1.endsWith("/")) {
            this.log(lineNumber, _MSG_INVALID_END_CHARACTER, new Object[]{Character.valueOf(literalString1.charAt(literalString1.length() - 1))});
        }
        if (literalString2.startsWith(" ") || !literalString1.endsWith(" ") && literalString2.matches("^[-:;.].*")) {
            this.log(lineNumber + 1, _MSG_INVALID_START_CHARACTER, new Object[]{Character.valueOf(literalString2.charAt(0))});
        }
    }

    protected int getMaxLineLength() {
        return GetterUtil.getInteger(this.getAttributeValue("maxLineLength"));
    }

    protected int getStringBreakPos(String s1, String s2, int i) {
        if (s2.startsWith("/")) {
            int pos = s2.lastIndexOf("/", i);
            if (pos > 0) {
                return pos - 1;
            }
            return -1;
        }
        if (s1.endsWith("-")) {
            return Math.max(s2.lastIndexOf("-", i - 1), s2.lastIndexOf(" ", i - 1));
        }
        if (s1.endsWith(".")) {
            return Math.max(s2.lastIndexOf(".", i - 1), s2.lastIndexOf(" ", i - 1));
        }
        if (s1.endsWith(" ")) {
            return s2.lastIndexOf(" ", i - 1);
        }
        return -1;
    }

    protected String getStringValue(DetailAST stringLiteralDetailAST) {
        String stringValue = stringLiteralDetailAST.getText();
        return stringValue.substring(1, stringValue.length() - 1);
    }
}

