/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJSPTermsCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPInlineVariableCheck
extends BaseJSPTermsCheck {
    private static final Pattern _chainedVariableDefinitionPattern = Pattern.compile("\n\t*[\\w<>\\[\\],\\? ]+ (\\w+) = ([^\n(]+(build|map|put)\\(\n)");
    private static final Pattern _getterVariableDefinitionPattern = Pattern.compile("\n\t*[\\w<>\\[\\],\\? ]+ (\\w+) = ((\\w+\\.)?get\\1\\(.)", 2);
    private static final Pattern _variableDefinitionPattern = Pattern.compile("\n\t*[\\w<>\\[\\],\\? ]+ (\\w+) = ([\\w.]+\\(.)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._inlineVariable(fileName, content, _chainedVariableDefinitionPattern, false);
        content = this._inlineVariable(fileName, content, _getterVariableDefinitionPattern, false);
        content = this._inlineVariable(fileName, content, _variableDefinitionPattern, true);
        return content;
    }

    private String _inlineVariable(String fileName, String content, Pattern variableDefinitionPattern, boolean checkSetterParameterOnly) throws IOException {
        Matcher variableDefinitionMatcher = variableDefinitionPattern.matcher(content);
        while (variableDefinitionMatcher.find()) {
            int z;
            String s;
            int x;
            if (!JSPSourceUtil.isJavaSource(content, variableDefinitionMatcher.start())) continue;
            String variableName = variableDefinitionMatcher.group(1);
            int y = x = variableDefinitionMatcher.start(2);
            String variableValue = null;
            while (this.getLevel(variableValue = content.substring(x, (y = content.indexOf(")", y + 1)) + 1)) != 0 || (s = content.substring(y + 1)).matches("(?s)\\.\\w+\\(.*")) {
            }
            Pattern pattern = null;
            pattern = checkSetterParameterOnly ? Pattern.compile(StringBundler.concat("(?i)set", variableName, "\\((", variableName, ")\\)")) : Pattern.compile("[\\(,]\\s*(" + variableName + ")\\s*[,\\)]");
            String s2 = content.substring(y + 1);
            if (!s2.startsWith(";\n")) continue;
            Matcher matcher = pattern.matcher(s2);
            x = -1;
            while (matcher.find()) {
                if (ToolsUtil.isInsideQuotes(s2, matcher.start(1))) continue;
                x = matcher.start();
                break;
            }
            if (x == -1 || (z = StringUtil.indexOfAny(s2, new String[]{"{\n", "\n}", "\t}", "%>\n"})) < x || this.hasVariableReference(s2, variableValue, matcher.start(1))) continue;
            int pos = y + matcher.start(1) - 1;
            String newContent = StringUtil.replaceFirst(content, variableName, variableValue, pos);
            this.populateContentsMap(fileName, content);
            HashSet<String> checkedFileNames = new HashSet<String>();
            HashSet<String> includeFileNames = new HashSet<String>();
            if (!this.hasUnusedJSPTerm(fileName, newContent, "\\W" + variableName + "\\W", this.getLineNumber(newContent, variableDefinitionMatcher.start(1)), "variable", checkedFileNames, includeFileNames, this.getContentsMap())) continue;
            String variableDeclaration = newContent.substring(variableDefinitionMatcher.start(), y + 2);
            return StringUtil.replaceFirst(newContent, variableDeclaration, "", variableDefinitionMatcher.start() - 1);
        }
        return content;
    }
}

