/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;

public class BNDBundleActivatorCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/bnd.bnd") && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this._checkBundleActivator(fileName, content);
        }
        return content;
    }

    private void _checkBundleActivator(String fileName, String content) {
        String bundleActivator = BNDSourceUtil.getDefinitionValue(content, "Bundle-Activator");
        if (bundleActivator == null) {
            return;
        }
        if (!bundleActivator.endsWith("BundleActivator")) {
            this.addMessage(fileName, "Incorrect Bundle-Activator, it should end with 'BundleActivator'");
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName == null) {
            return;
        }
        int x = bundleActivator.lastIndexOf(".");
        int y = bundleActivator.lastIndexOf("BundleActivator");
        String strippedBundleActivator = bundleActivator.substring(x + 1, y);
        String strippedBundleSymbolicName = StringUtil.removeChar(bundleSymbolicName, '.');
        if (!StringUtil.endsWith(strippedBundleSymbolicName, strippedBundleActivator)) {
            this.addMessage(fileName, "Incorrect Bundle-Activator, it should match 'Bundle-SymbolicName'");
        }
    }
}

