/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

public class ImportPackage
implements Comparable<ImportPackage> {
    private final String _importString;
    private boolean _isStatic;
    private final String _line;

    public ImportPackage(String importString, boolean isStatic, String line) {
        this._importString = importString;
        this._isStatic = isStatic;
        this._line = line;
    }

    @Deprecated
    public ImportPackage(String importString, boolean isStatic, String line, boolean bndImport) {
        this._importString = importString;
        this._isStatic = isStatic;
        this._line = line;
    }

    @Override
    public int compareTo(ImportPackage importPackage) {
        if (this._isStatic != importPackage.isStatic()) {
            if (this._isStatic) {
                return -1;
            }
            return 1;
        }
        String importPackageImportString = importPackage.getImportString();
        int value = this._importString.compareTo(importPackageImportString);
        if (this._importString.startsWith("!") || importPackageImportString.startsWith("!")) {
            return value;
        }
        return value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImportPackage)) {
            return false;
        }
        ImportPackage importPackage = (ImportPackage)object;
        return this._isStatic == importPackage.isStatic() && this._importString.equals(importPackage.getImportString());
    }

    public String getImportString() {
        return this._importString;
    }

    public String getLine() {
        return this._line;
    }

    public String getPackageLevel() {
        int pos = this._importString.indexOf("/");
        if (pos != -1) {
            if ((pos = this._importString.indexOf("/", pos + 1)) == -1) {
                return this._importString;
            }
            return this._importString.substring(0, pos);
        }
        pos = this._importString.indexOf(".");
        if ((pos = this._importString.indexOf(".", pos + 1)) == -1) {
            pos = this._importString.indexOf(".");
        }
        if (pos == -1) {
            return this._importString;
        }
        return this._importString.substring(0, pos);
    }

    public int hashCode() {
        return this._importString.hashCode();
    }

    public boolean isGroupedWith(ImportPackage importPackage) {
        if (this._importString.equals("*")) {
            return false;
        }
        String importPackageImportString = importPackage.getImportString();
        if (importPackageImportString.equals("*")) {
            return false;
        }
        if (this._isStatic != importPackage.isStatic()) {
            return false;
        }
        String packageLevel = this.getPackageLevel();
        return packageLevel.equals(importPackage.getPackageLevel());
    }

    public boolean isStatic() {
        return this._isStatic;
    }
}

