/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.ExcludeSyntax;
import com.liferay.source.formatter.ExcludeSyntaxPattern;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SourceFormatterUtil {
    public static final String CHECKSTYLE_DOCUMENTATION_URL_BASE = "https://checkstyle.sourceforge.io/";
    public static final String GIT_LIFERAY_PORTAL_BRANCH = "git.liferay.portal.branch";
    public static final String GIT_LIFERAY_PORTAL_URL = "https://raw.githubusercontent.com/liferay/liferay-portal/";
    public static final String SOURCE_FORMATTER_TEST_PATH = "/source/formatter/dependencies/";
    private static final String _DOCUMENTATION_URL = "https://github.com/liferay/liferay-portal/blob/master/modules/util/source-formatter/src/main/resources/documentation/checks/";
    private static final String _SUPPRESSIONS_FILE_NAME = "source-formatter-suppressions.xml";
    private static final Log _log = LogFactoryUtil.getLog(SourceFormatterUtil.class);

    public static List<String> filterFileNames(List<String> allFileNames, String[] excludes, String[] includes, SourceFormatterExcludes sourceFormatterExcludes, boolean forceIncludeAllFiles) {
        ArrayList<String> excludeRegexList = new ArrayList<String>();
        HashMap excludeRegexMap = new HashMap();
        ArrayList<String> includeRegexList = new ArrayList<String>();
        for (String exclude : excludes) {
            if (exclude.contains("$")) continue;
            excludeRegexList.add(SourceFormatterUtil._createRegex(exclude));
        }
        if (!forceIncludeAllFiles) {
            Map<String, List<ExcludeSyntaxPattern>> excludeSyntaxPatternsMap = sourceFormatterExcludes.getExcludeSyntaxPatternsMap();
            for (Map.Entry entry : excludeSyntaxPatternsMap.entrySet()) {
                List excludeSyntaxPatterns = (List)entry.getValue();
                ArrayList<String> regexList = new ArrayList<String>();
                for (ExcludeSyntaxPattern excludeSyntaxPattern : excludeSyntaxPatterns) {
                    String string = excludeSyntaxPattern.getExcludePattern();
                    ExcludeSyntax excludeSyntax = excludeSyntaxPattern.getExcludeSyntax();
                    if (excludeSyntax.equals((Object)ExcludeSyntax.REGEX)) {
                        regexList.add(string);
                        continue;
                    }
                    if (string.contains("$")) continue;
                    regexList.add(SourceFormatterUtil._createRegex(string));
                }
                excludeRegexMap.put(entry.getKey(), regexList);
            }
        }
        for (String include : includes) {
            if (include.contains("$")) continue;
            includeRegexList.add(SourceFormatterUtil._createRegex(include));
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        block4: for (String fileName : allFileNames) {
            String encodedFileName = SourceUtil.getAbsolutePath(fileName);
            for (String includeRegex : includeRegexList) {
                if (!encodedFileName.matches(includeRegex)) continue;
                for (String string : excludeRegexList) {
                    if (!encodedFileName.matches(string)) continue;
                    continue block4;
                }
                for (Map.Entry entry : excludeRegexMap.entrySet()) {
                    String propertiesFileLocation = (String)entry.getKey();
                    if (!encodedFileName.startsWith(propertiesFileLocation)) continue;
                    for (String excludeRegex : (List)entry.getValue()) {
                        if (!encodedFileName.matches(excludeRegex)) continue;
                        continue block4;
                    }
                }
                fileNames.add(fileName);
                continue block4;
            }
        }
        return fileNames;
    }

    public static List<String> filterRecentChangesFileNames(Set<String> recentChangesFileNames, String[] excludes, String[] includes, SourceFormatterExcludes sourceFormatterExcludes) throws IOException {
        if (ArrayUtil.isEmpty(includes)) {
            return new ArrayList<String>();
        }
        PathMatchers pathMatchers = SourceFormatterUtil._getPathMatchers(excludes, includes, sourceFormatterExcludes);
        return SourceFormatterUtil._filterRecentChangesFileNames(recentChangesFileNames, pathMatchers);
    }

    public static String getDocumentationURLString(Class<?> checkClass) {
        String documentationURLString = SourceFormatterUtil._getDocumentationURLString(checkClass.getSimpleName());
        if (documentationURLString != null) {
            return documentationURLString;
        }
        Class<?> superclass = checkClass.getSuperclass();
        String className = superclass.getSimpleName();
        documentationURLString = SourceFormatterUtil._getDocumentationURLString(className);
        if (documentationURLString != null || !className.startsWith("Base")) {
            return documentationURLString;
        }
        return SourceFormatterUtil._getDocumentationURLString(className.substring(4));
    }

    public static File getFile(String baseDirName, String fileName, int level) {
        for (int i = 0; i < level; ++i) {
            File file = new File(baseDirName + fileName);
            if (file.exists()) {
                return file;
            }
            fileName = "../" + fileName;
        }
        return null;
    }

    public static String getGitContent(String fileName, String branchName) {
        URL url = SourceFormatterUtil.getPortalGitURL(fileName, branchName);
        if (url == null) {
            return null;
        }
        try {
            return StringUtil.read(url.openStream());
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug(ioException, ioException);
            }
            return null;
        }
    }

    public static String getMarkdownFileName(String camelCaseName) {
        camelCaseName = camelCaseName.replaceAll("([A-Z])s([A-Z])", "$1S$2");
        String markdownFileName = TextFormatter.format(camelCaseName, 10);
        markdownFileName = TextFormatter.format(markdownFileName, 13);
        return markdownFileName + ".markdown";
    }

    public static File getPortalDir(String baseDirName) {
        File portalImplDir = SourceFormatterUtil.getFile(baseDirName, "portal-impl", 7);
        if (portalImplDir == null) {
            return null;
        }
        return portalImplDir.getParentFile();
    }

    public static URL getPortalGitURL(String fileName, String portalBranchName) {
        if (Validator.isNull(portalBranchName)) {
            return null;
        }
        try {
            return new URL(StringBundler.concat(GIT_LIFERAY_PORTAL_URL, portalBranchName, "/", fileName));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return null;
        }
    }

    public static String getSimpleName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static List<File> getSuppressionsFiles(String baseDirName, List<String> allFileNames, SourceFormatterExcludes sourceFormatterExcludes) {
        ArrayList<File> suppressionsFiles = new ArrayList<File>();
        String parentDirName = baseDirName;
        for (int j = 0; j < 7; ++j) {
            File suppressionsFile = new File(parentDirName + _SUPPRESSIONS_FILE_NAME);
            if (suppressionsFile.exists()) {
                suppressionsFiles.add(suppressionsFile);
            }
            parentDirName = parentDirName + "../";
        }
        List<String> moduleSuppressionsFileNames = SourceFormatterUtil.filterFileNames(allFileNames, new String[0], new String[]{"**/source-formatter-suppressions.xml"}, sourceFormatterExcludes, true);
        for (String moduleSuppressionsFileName : moduleSuppressionsFileNames) {
            moduleSuppressionsFileName = StringUtil.replace(moduleSuppressionsFileName, '\\', '/');
            suppressionsFiles.add(new File(moduleSuppressionsFileName));
        }
        return suppressionsFiles;
    }

    public static void printError(String fileName, File file) {
        SourceFormatterUtil.printError(fileName, file.toString());
    }

    public static void printError(String fileName, String message) {
        System.out.println(message);
    }

    public static List<String> scanForFiles(String baseDirName, String[] excludes, String[] includes, SourceFormatterExcludes sourceFormatterExcludes, boolean includeSubrepositories) throws IOException {
        if (ArrayUtil.isEmpty(includes)) {
            return new ArrayList<String>();
        }
        PathMatchers pathMatchers = SourceFormatterUtil._getPathMatchers(excludes, includes, sourceFormatterExcludes);
        return SourceFormatterUtil._scanForFiles(baseDirName, pathMatchers, includeSubrepositories);
    }

    private static String _createRegex(String s) {
        if (!s.startsWith("**/")) {
            s = "**/" + s;
        }
        s = StringUtil.replace(s, '.', "\\.");
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c1 = s.charAt(i);
            if (c1 != '*') {
                sb.append(c1);
                continue;
            }
            if (i == s.length() - 1) {
                sb.append("[^/]*");
                continue;
            }
            char c2 = s.charAt(i + 1);
            if (c2 == '*') {
                sb.append(".*");
                ++i;
                continue;
            }
            sb.append("[^/]*");
        }
        return sb.toString();
    }

    private static List<String> _filterRecentChangesFileNames(Set<String> recentChangesFileNames, PathMatchers pathMatchers) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        block0: for (String fileName : recentChangesFileNames) {
            File file = new File(fileName);
            File canonicalFile = file.getCanonicalFile();
            Path filePath = canonicalFile.toPath();
            for (PathMatcher pathMatcher : pathMatchers.getExcludeFilePathMatchers()) {
                if (!pathMatcher.matches(filePath)) continue;
                continue block0;
            }
            String currentFilePath = SourceUtil.getAbsolutePath(filePath);
            Map<String, List<PathMatcher>> excludeFilePathMatchersMap = pathMatchers.getExcludeFilePathMatchersMap();
            for (Map.Entry<String, List<PathMatcher>> entry : excludeFilePathMatchersMap.entrySet()) {
                String propertiesFileLocation = entry.getKey();
                if (!currentFilePath.startsWith(propertiesFileLocation)) continue;
                for (PathMatcher pathMatcher : entry.getValue()) {
                    if (!pathMatcher.matches(filePath)) continue;
                    continue block0;
                }
            }
            File dir = file.getParentFile();
            do {
                File canonicalDir = dir.getCanonicalFile();
                Path dirPath = canonicalDir.toPath();
                for (PathMatcher pathMatcher : pathMatchers.getExcludeDirPathMatchers()) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    continue block0;
                }
                String currentDirPath = SourceUtil.getAbsolutePath(dirPath);
                Map<String, List<PathMatcher>> excludeDirPathMatchersMap = pathMatchers.getExcludeDirPathMatchersMap();
                for (Map.Entry<String, List<PathMatcher>> entry : excludeDirPathMatchersMap.entrySet()) {
                    String propertiesFileLocation = entry.getKey();
                    if (!currentDirPath.startsWith(propertiesFileLocation)) continue;
                    for (PathMatcher pathMatcher : entry.getValue()) {
                        if (!pathMatcher.matches(dirPath)) continue;
                        continue block0;
                    }
                }
                if (Files.exists(dirPath.resolve("source_formatter.ignore"), new LinkOption[0])) continue block0;
            } while ((dir = dir.getParentFile()) != null);
            for (PathMatcher pathMatcher : pathMatchers.getIncludeFilePathMatchers()) {
                if (!pathMatcher.matches(filePath)) continue;
                Path curFilePath = Paths.get(fileName, new String[0]);
                fileNames.add(curFilePath.toString());
                continue block0;
            }
        }
        return fileNames;
    }

    private static Path _getCanonicalPath(Path path) {
        try {
            File file = path.toFile();
            File canonicalFile = file.getCanonicalFile();
            return canonicalFile.toPath();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static String _getDocumentationURLString(String checkName) {
        String markdownFileName = SourceFormatterUtil.getMarkdownFileName(checkName);
        ClassLoader classLoader = SourceFormatterUtil.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("documentation/checks/" + markdownFileName);
        if (inputStream != null) {
            return _DOCUMENTATION_URL + markdownFileName;
        }
        return null;
    }

    private static PathMatchers _getPathMatchers(String[] excludes, String[] includes, SourceFormatterExcludes sourceFormatterExcludes) {
        PathMatchers pathMatchers = new PathMatchers(FileSystems.getDefault());
        for (String exclude : excludes) {
            pathMatchers.addExcludeSyntaxPattern(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        for (ExcludeSyntaxPattern excludeSyntaxPattern : sourceFormatterExcludes.getDefaultExcludeSyntaxPatterns()) {
            pathMatchers.addExcludeSyntaxPattern(excludeSyntaxPattern);
        }
        Map<String, List<ExcludeSyntaxPattern>> excludeSyntaxPatternsMap = sourceFormatterExcludes.getExcludeSyntaxPatternsMap();
        for (Map.Entry<String, List<ExcludeSyntaxPattern>> entry : excludeSyntaxPatternsMap.entrySet()) {
            pathMatchers.addExcludeSyntaxPatterns(entry.getKey(), entry.getValue());
        }
        for (String include : includes) {
            pathMatchers.addInclude(include);
        }
        return pathMatchers;
    }

    private static List<String> _scanForFiles(final String baseDirName, final PathMatchers pathMatchers, final boolean includeSubrepositories) throws IOException {
        final ArrayList<String> fileNames = new ArrayList<String>();
        Files.walkFileTree(Paths.get(baseDirName, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                String currentDirPath;
                block8: {
                    Path gitRepoPath;
                    Object baseDirPath;
                    if (Files.exists(dirPath.resolve("source_formatter.ignore"), new LinkOption[0])) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    currentDirPath = SourceUtil.getAbsolutePath(dirPath);
                    if (!includeSubrepositories && !((String)(baseDirPath = SourceUtil.getAbsolutePath(baseDirName))).equals(currentDirPath) && Files.exists(gitRepoPath = dirPath.resolve(".gitrepo"), new LinkOption[0])) {
                        try {
                            String content = FileUtil.read(gitRepoPath.toFile());
                            if (content.contains("autopull = true")) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                        }
                        catch (Exception exception) {
                            if (!_log.isDebugEnabled()) break block8;
                            _log.debug(exception, exception);
                        }
                    }
                }
                dirPath = SourceFormatterUtil._getCanonicalPath(dirPath);
                for (PathMatcher pathMatcher : pathMatchers.getExcludeDirPathMatchers()) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Map<String, List<PathMatcher>> excludeDirPathMatchersMap = pathMatchers.getExcludeDirPathMatchersMap();
                for (Map.Entry<String, List<PathMatcher>> entry : excludeDirPathMatchersMap.entrySet()) {
                    String propertiesFileLocation = entry.getKey();
                    if (!currentDirPath.startsWith(propertiesFileLocation)) continue;
                    for (PathMatcher pathMatcher : entry.getValue()) {
                        if (!pathMatcher.matches(dirPath)) continue;
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                Path canonicalPath = SourceFormatterUtil._getCanonicalPath(filePath);
                for (PathMatcher pathMatcher : pathMatchers.getExcludeFilePathMatchers()) {
                    if (!pathMatcher.matches(canonicalPath)) continue;
                    return FileVisitResult.CONTINUE;
                }
                String currentFilePath = SourceUtil.getAbsolutePath(filePath);
                Map<String, List<PathMatcher>> excludeFilePathMatchersMap = pathMatchers.getExcludeFilePathMatchersMap();
                for (Map.Entry<String, List<PathMatcher>> entry : excludeFilePathMatchersMap.entrySet()) {
                    String propertiesFileLocation = entry.getKey();
                    if (!currentFilePath.startsWith(propertiesFileLocation)) continue;
                    for (PathMatcher pathMatcher : entry.getValue()) {
                        if (!pathMatcher.matches(canonicalPath)) continue;
                        return FileVisitResult.CONTINUE;
                    }
                }
                for (PathMatcher pathMatcher : pathMatchers.getIncludeFilePathMatchers()) {
                    if (!pathMatcher.matches(canonicalPath)) continue;
                    fileNames.add(filePath.toString());
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileNames;
    }

    private static class PathMatchers {
        private List<PathMatcher> _excludeDirPathMatchers = new ArrayList<PathMatcher>();
        private Map<String, List<PathMatcher>> _excludeDirPathMatchersMap = new HashMap<String, List<PathMatcher>>();
        private List<PathMatcher> _excludeFilePathMatchers = new ArrayList<PathMatcher>();
        private Map<String, List<PathMatcher>> _excludeFilePathMatchersMap = new HashMap<String, List<PathMatcher>>();
        private final FileSystem _fileSystem;
        private List<PathMatcher> _includeFilePathMatchers = new ArrayList<PathMatcher>();

        public PathMatchers(FileSystem fileSystem) {
            this._fileSystem = fileSystem;
        }

        public void addExcludeSyntaxPattern(ExcludeSyntaxPattern excludeSyntaxPattern) {
            String excludePattern = excludeSyntaxPattern.getExcludePattern();
            ExcludeSyntax excludeSyntax = excludeSyntaxPattern.getExcludeSyntax();
            if (excludeSyntax.equals((Object)ExcludeSyntax.GLOB) && !excludePattern.startsWith("**/")) {
                excludePattern = "**/" + excludePattern;
            }
            if (excludeSyntax.equals((Object)ExcludeSyntax.GLOB) && excludePattern.endsWith("/**")) {
                excludePattern = excludePattern.substring(0, excludePattern.length() - 3);
                this._excludeDirPathMatchers.add(this._fileSystem.getPathMatcher(excludeSyntax.getValue() + ":" + excludePattern));
            } else if (excludeSyntax.equals((Object)ExcludeSyntax.REGEX) && excludePattern.endsWith(Pattern.quote(File.separator) + ".*")) {
                excludePattern = StringUtil.replaceLast(excludePattern, Pattern.quote(File.separator) + ".*", "");
                this._excludeDirPathMatchers.add(this._fileSystem.getPathMatcher(excludeSyntax.getValue() + ":" + excludePattern));
            } else {
                this._excludeFilePathMatchers.add(this._fileSystem.getPathMatcher(excludeSyntax.getValue() + ":" + excludePattern));
            }
        }

        public void addExcludeSyntaxPatterns(String propertiesFileLocation, List<ExcludeSyntaxPattern> excludeSyntaxPatterns) {
            ArrayList<PathMatcher> excludeDirPathMatcherList = new ArrayList<PathMatcher>();
            ArrayList<PathMatcher> excludeFilePathMatcherList = new ArrayList<PathMatcher>();
            for (ExcludeSyntaxPattern excludeSyntaxPattern : excludeSyntaxPatterns) {
                String excludePattern = excludeSyntaxPattern.getExcludePattern();
                ExcludeSyntax excludeSyntax = excludeSyntaxPattern.getExcludeSyntax();
                if (excludeSyntax.equals((Object)ExcludeSyntax.GLOB) && !excludePattern.startsWith("**/")) {
                    excludePattern = "**/" + excludePattern;
                }
                if (excludeSyntax.equals((Object)ExcludeSyntax.GLOB) && excludePattern.endsWith("/**")) {
                    excludePattern = excludePattern.substring(0, excludePattern.length() - 3);
                    excludeDirPathMatcherList.add(this._fileSystem.getPathMatcher(excludeSyntax.getValue() + ":" + excludePattern));
                    continue;
                }
                if (excludeSyntax.equals((Object)ExcludeSyntax.REGEX) && excludePattern.endsWith(Pattern.quote(File.separator) + ".*")) {
                    excludePattern = StringUtil.replaceLast(excludePattern, Pattern.quote(File.separator) + ".*", "");
                    excludeDirPathMatcherList.add(this._fileSystem.getPathMatcher(excludeSyntax.getValue() + ":" + excludePattern));
                    continue;
                }
                excludeFilePathMatcherList.add(this._fileSystem.getPathMatcher(excludeSyntax.getValue() + ":" + excludePattern));
            }
            this._excludeDirPathMatchersMap.put(propertiesFileLocation, excludeDirPathMatcherList);
            this._excludeFilePathMatchersMap.put(propertiesFileLocation, excludeFilePathMatcherList);
        }

        public void addInclude(String include) {
            this._includeFilePathMatchers.add(this._fileSystem.getPathMatcher("glob:" + include));
        }

        public List<PathMatcher> getExcludeDirPathMatchers() {
            return this._excludeDirPathMatchers;
        }

        public Map<String, List<PathMatcher>> getExcludeDirPathMatchersMap() {
            return this._excludeDirPathMatchersMap;
        }

        public List<PathMatcher> getExcludeFilePathMatchers() {
            return this._excludeFilePathMatchers;
        }

        public Map<String, List<PathMatcher>> getExcludeFilePathMatchersMap() {
            return this._excludeFilePathMatchersMap;
        }

        public List<PathMatcher> getIncludeFilePathMatchers() {
            return this._includeFilePathMatchers;
        }
    }
}

