/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaConstructorParametersCheck
extends BaseJavaTermCheck {
    private static final Pattern _assignCallPattern = Pattern.compile("\t(_|this\\.)(\\w+) (=[^;]+;)\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaSignature signature = javaTerm.getSignature();
        List<JavaParameter> parameters = signature.getParameters();
        if (!parameters.isEmpty()) {
            this._checkConstructorParameterOrder(fileName, javaTerm, parameters);
            String content = this._sortAssignCalls(javaTerm.getContent(), parameters);
            return this._fixIncorrectEmptyLines(content, parameters);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR};
    }

    private void _checkConstructorParameterOrder(String fileName, JavaTerm javaTerm, List<JavaParameter> parameters) {
        String previousGlobalVariableName = null;
        String previousParameterName = null;
        int previousPos = -1;
        for (JavaParameter parameter : parameters) {
            String beforeParameter;
            String parameterName = parameter.getParameterName();
            Pattern pattern = Pattern.compile(StringBundler.concat("\\{\n([\\s\\S]*?)((_|this\\.)", parameterName, ") =[ \t\n]+", parameterName, ";"));
            Matcher matcher = pattern.matcher(javaTerm.getContent());
            if (!matcher.find() || (beforeParameter = matcher.group(1)).contains(parameterName + " =")) continue;
            int pos = matcher.start(2);
            if (previousPos > pos && previousGlobalVariableName.startsWith(matcher.group(3))) {
                this.addMessage(fileName, StringBundler.concat("'", previousGlobalVariableName, " = ", previousParameterName, ";' should come before '", matcher.group(2), " = ", parameterName, ";' to match order of constructor parameters"), javaTerm.getLineNumber(previousPos));
                return;
            }
            previousGlobalVariableName = matcher.group(2);
            previousParameterName = parameterName;
            previousPos = pos;
        }
    }

    private String _fixIncorrectEmptyLines(String content, List<JavaParameter> parameters) {
        for (int i = 1; i < parameters.size(); ++i) {
            JavaParameter parameter = parameters.get(i);
            JavaParameter previousParameter = parameters.get(i - 1);
            String name = parameter.getParameterName();
            String previousName = previousParameter.getParameterName();
            Pattern pattern = Pattern.compile(StringBundler.concat("\t_", previousName, " =[ \t\n]+", previousName, ";(\n\n)\t+_", name, " =[ \t\n]+", name, ";\n"));
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find() || this._getOccurenceCount(content, name) != 2 || this._getOccurenceCount(content, "_" + name) != 1 || this._getOccurenceCount(content, previousName) != 2 || this._getOccurenceCount(content, "_" + previousName) != 1) continue;
            return StringUtil.replaceFirst(content, "\n", "", matcher.start(1));
        }
        return content;
    }

    private int _getIndex(String name, String value, List<JavaParameter> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            JavaParameter parameter = parameters.get(i);
            String parameterName = parameter.getParameterName();
            if (!name.equals(parameterName)) continue;
            if (value.matches("(?s).*\\W" + parameterName + "\\W.*")) {
                return i;
            }
            return parameters.size();
        }
        return parameters.size();
    }

    private int _getOccurenceCount(String content, String name) {
        int count = 0;
        Pattern pattern = Pattern.compile("\\W" + name + "\\W");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    private String _sortAssignCalls(String content, List<JavaParameter> parameters) {
        String firstFollowingStatement = null;
        Matcher assignCallMatcher = _assignCallPattern.matcher(content);
        while (assignCallMatcher.find()) {
            int index2;
            String followingCode;
            Pattern nextCallPattern = Pattern.compile("^\t+" + assignCallMatcher.group(1) + "(\\w+) (=[^;]+;)\\n");
            Matcher nextCallMatcher = nextCallPattern.matcher(followingCode = content.substring(assignCallMatcher.end()));
            if (!nextCallMatcher.find()) continue;
            int index1 = this._getIndex(assignCallMatcher.group(2), assignCallMatcher.group(3), parameters);
            if (index1 > (index2 = this._getIndex(nextCallMatcher.group(1), nextCallMatcher.group(2), parameters))) {
                String assignment1 = StringUtil.trim(assignCallMatcher.group());
                String assignment2 = StringUtil.trim(nextCallMatcher.group());
                content = StringUtil.replaceFirst(content, assignment2, assignment1, assignCallMatcher.start());
                content = StringUtil.replaceFirst(content, assignment1, assignment2, assignCallMatcher.start());
                return this._sortAssignCalls(content, parameters);
            }
            if (index1 == index2 || index2 != parameters.size()) continue;
            firstFollowingStatement = nextCallMatcher.group();
        }
        if (firstFollowingStatement != null) {
            return StringUtil.replaceFirst(content, firstFollowingStatement, "\n" + firstFollowingStatement);
        }
        return content;
    }
}

