/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.ProtectedObjectInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProtectedClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.ObjectOutputStream;

public class Base64 {
    private static final Log _log = LogFactoryUtil.getLog(Base64.class);

    public static byte[] decode(String base64) {
        return Base64._decode(base64, false);
    }

    public static byte[] decodeFromURL(String base64) {
        return Base64._decode(base64, true);
    }

    public static String encode(byte[] raw) {
        return Base64._encode(raw, 0, raw.length, false);
    }

    public static String encodeToURL(byte[] raw) {
        return Base64._encode(raw, 0, raw.length, true);
    }

    public static String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(32000);
        try (ObjectOutputStream os = new ObjectOutputStream(unsyncByteArrayOutputStream);){
            os.writeObject(object);
        }
        catch (Exception exception) {
            _log.error(exception, exception);
        }
        return Base64._encode(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size(), false);
    }

    public static Object stringToObject(String s) {
        return Base64._stringToObject(s, null, false);
    }

    public static Object stringToObject(String s, ClassLoader classLoader) {
        return Base64._stringToObject(s, classLoader, false);
    }

    public static Object stringToObjectSilent(String s) {
        return Base64._stringToObject(s, null, true);
    }

    private static byte[] _decode(String base64, boolean url) {
        if (Validator.isNull(base64)) {
            return new byte[0];
        }
        int pad = 0;
        int i = base64.length() - 1;
        while (base64.charAt(i) == '=') {
            ++pad;
            --i;
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawindex = 0;
        for (int i2 = 0; i2 < base64.length(); i2 += 4) {
            int block = Base64._getValue(base64.charAt(i2), url) << 18;
            block += Base64._getValue(base64.charAt(i2 + 1), url) << 12;
            block += Base64._getValue(base64.charAt(i2 + 2), url) << 6;
            block += Base64._getValue(base64.charAt(i2 + 3), url);
            for (int j = 0; j < 3 && rawindex + j < raw.length; ++j) {
                raw[rawindex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
            }
            rawindex += 3;
        }
        return raw;
    }

    private static String _encode(byte[] raw, int offset, int length, boolean url) {
        int lastIndex = Math.min(raw.length, offset + length);
        StringBuilder sb = new StringBuilder(((lastIndex - offset) / 3 + 1) * 4);
        for (int i = offset; i < lastIndex; i += 3) {
            sb.append(Base64._encodeBlock(raw, i, lastIndex, url));
        }
        return sb.toString();
    }

    private static char[] _encodeBlock(byte[] raw, int offset, int lastIndex, boolean url) {
        int block = 0;
        int slack = lastIndex - offset - 1;
        int end = slack < 2 ? slack : 2;
        for (int i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b >= 0 ? b : b + 256;
            block += neuter << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = Base64._getChar(sixbit, url);
        }
        if (url) {
            if (slack < 1) {
                base64[2] = 42;
            }
            if (slack < 2) {
                base64[3] = 42;
            }
        } else {
            if (slack < 1) {
                base64[2] = 61;
            }
            if (slack < 2) {
                base64[3] = 61;
            }
        }
        return base64;
    }

    private static char _getChar(int sixbit, boolean url) {
        if (sixbit >= 0 && sixbit <= 25) {
            return (char)(65 + sixbit);
        }
        if (sixbit >= 26 && sixbit <= 51) {
            return (char)(97 + (sixbit - 26));
        }
        if (sixbit >= 52 && sixbit <= 61) {
            return (char)(48 + (sixbit - 52));
        }
        if (sixbit == 62) {
            if (url) {
                return '-';
            }
            return '+';
        }
        if (sixbit != 63) {
            return '?';
        }
        if (url) {
            return '_';
        }
        return '/';
    }

    private static int _getValue(char c, boolean url) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (url) {
            if (c == '-') {
                return 62;
            }
            if (c == '_') {
                return 63;
            }
            if (c != '*') {
                return -1;
            }
        } else {
            if (c == '+') {
                return 62;
            }
            if (c == '/') {
                return 63;
            }
            if (c != '=') {
                return -1;
            }
        }
        return 0;
    }

    private static Object _stringToObject(String s, ClassLoader classLoader, boolean silent) {
        if (s == null) {
            return null;
        }
        byte[] bytes = Base64._decode(s, false);
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(bytes);
        try {
            Object objectInputStream = null;
            objectInputStream = classLoader == null ? new ProtectedObjectInputStream((InputStream)unsyncByteArrayInputStream) : new ProtectedClassLoaderObjectInputStream(unsyncByteArrayInputStream, classLoader);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            if (!silent) {
                _log.error(exception, exception);
            }
            return null;
        }
    }
}

