/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.SourceFormatterCheckUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.InputSource;

public class CheckstyleUtil {
    public static final String BASE_DIR_NAME_KEY = "baseDirName";
    public static final int BATCH_SIZE = 1000;
    public static final String MAX_LINE_LENGTH_KEY = "maxLineLength";
    public static final String SHOW_DEBUG_INFORMATION_KEY = "showDebugInformation";
    private static final String _ATTRIBUTES_KEY = "attributes";
    private static final String _EXCLUDES_KEY = "excludes";

    public static Configuration getConfiguration(String configurationFileName, Map<String, Properties> propertiesMap, SourceFormatterArgs sourceFormatterArgs) throws CheckstyleException {
        ClassLoader classLoader = CheckstyleUtil.class.getClassLoader();
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(classLoader.getResourceAsStream(configurationFileName)), (PropertyResolver)new PropertiesExpander(System.getProperties()), (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.EXECUTE);
        DefaultConfiguration treeWalkerConfiguration = CheckstyleUtil._getChildConfiguration(configuration, "TreeWalker");
        Configuration[] checkConfigurations = treeWalkerConfiguration.getChildren();
        if (checkConfigurations == null) {
            return configuration;
        }
        JSONObject excludesJSONObject = SourceFormatterCheckUtil.getExcludesJSONObject(propertiesMap);
        ArrayList<String> checkNames = new ArrayList<String>();
        List<String> filterCheckNames = sourceFormatterArgs.getCheckNames();
        for (Configuration checkConfiguration : checkConfigurations) {
            if (!(checkConfiguration instanceof DefaultConfiguration)) continue;
            String checkName = checkConfiguration.getName();
            String checkSimpleName = SourceFormatterUtil.getSimpleName(checkName);
            if (!filterCheckNames.isEmpty() && !filterCheckNames.contains(checkSimpleName)) {
                treeWalkerConfiguration.removeChild(checkConfiguration);
                continue;
            }
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration(checkName);
            Map messages = checkConfiguration.getMessages();
            for (Map.Entry entry : messages.entrySet()) {
                defaultConfiguration.addMessage((String)entry.getKey(), (String)entry.getValue());
            }
            if (checkName.startsWith("com.liferay.")) {
                checkNames.add(checkSimpleName);
                if (excludesJSONObject.length() != 0) {
                    defaultConfiguration.addAttribute(_EXCLUDES_KEY, excludesJSONObject.toString());
                }
                JSONObject attributesJSONObject = CheckstyleUtil._getAttributesJSONObject(propertiesMap, checkSimpleName, checkConfiguration, sourceFormatterArgs);
                defaultConfiguration.addAttribute(_ATTRIBUTES_KEY, attributesJSONObject.toString());
            } else {
                for (String attributeName : checkConfiguration.getAttributeNames()) {
                    if (attributeName.equals("category") || attributeName.equals("description") || attributeName.equals("documentationLocation")) continue;
                    defaultConfiguration.addAttribute(attributeName, checkConfiguration.getAttribute(attributeName));
                }
            }
            treeWalkerConfiguration.removeChild(checkConfiguration);
            treeWalkerConfiguration.addChild((Configuration)defaultConfiguration);
        }
        if (sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.addCheckNames(CheckType.CHECKSTYLE, checkNames);
        }
        return configuration;
    }

    public static List<String> getLines(String s) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(s));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private static JSONObject _addCustomAttributes(JSONObject jsonObject, String[][] attributesArray) {
        for (String[] values : attributesArray) {
            JSONArrayImpl jsonArray = new JSONArrayImpl();
            jsonArray.put(values[1]);
            jsonObject.put(values[0], jsonArray);
        }
        return jsonObject;
    }

    private static JSONObject _getAttributesJSONObject(Map<String, Properties> propertiesMap, String checkName, Configuration configuration, SourceFormatterArgs sourceFormatterArgs) throws CheckstyleException {
        JSONObject attributesJSONObject = new JSONObjectImpl();
        JSONObject configurationAttributesJSONObject = CheckstyleUtil._getConfigurationAttributesJSONObject(configuration);
        configurationAttributesJSONObject = CheckstyleUtil._addCustomAttributes(configurationAttributesJSONObject, new String[][]{{BASE_DIR_NAME_KEY, sourceFormatterArgs.getBaseDirName()}, {MAX_LINE_LENGTH_KEY, String.valueOf(sourceFormatterArgs.getMaxLineLength())}, {SHOW_DEBUG_INFORMATION_KEY, String.valueOf(sourceFormatterArgs.isShowDebugInformation())}});
        attributesJSONObject.put("configuration_file_location", configurationAttributesJSONObject);
        attributesJSONObject = SourceFormatterCheckUtil.addPropertiesAttributes(attributesJSONObject, propertiesMap, "git.liferay.portal.branch");
        attributesJSONObject = SourceFormatterCheckUtil.addPropertiesAttributes(attributesJSONObject, propertiesMap, CheckType.CHECKSTYLE, checkName);
        return attributesJSONObject;
    }

    private static DefaultConfiguration _getChildConfiguration(Configuration configuration, String name) {
        if (!(configuration instanceof DefaultConfiguration)) {
            return null;
        }
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)configuration;
        for (Configuration childConfiguration : defaultConfiguration.getChildren()) {
            String configurationName = childConfiguration.getName();
            if (!configurationName.equals(name) || !(childConfiguration instanceof DefaultConfiguration)) continue;
            return (DefaultConfiguration)childConfiguration;
        }
        return null;
    }

    private static JSONObject _getConfigurationAttributesJSONObject(Configuration configuration) throws CheckstyleException {
        JSONObjectImpl configurationAttributesJSONObject = new JSONObjectImpl();
        for (String attributeName : configuration.getAttributeNames()) {
            String[] values;
            JSONArrayImpl jsonArray = new JSONArrayImpl();
            for (String value : values = StringUtil.split(configuration.getAttribute(attributeName), ",")) {
                jsonArray.put(value);
            }
            configurationAttributesJSONObject.put(attributeName, jsonArray);
        }
        return configurationAttributesJSONObject;
    }
}

