/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesStylingCheck
extends BaseFileCheck {
    private static final Pattern _sqlPattern1 = Pattern.compile("(?<=\n)( +)(test.batch.run.property.query.+]=)([^\\\\].+)");
    private static final Pattern _sqlPattern2 = Pattern.compile("\\s(\\(.* ([!=]=|~) .+\\))( (AND|OR) )?(\\\\)?");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = content.replaceAll("(\n\n)( *#+)( [^#\\s])", "$1$2\n$2$3");
        content = content.replaceAll("(\n)( *#+)( [^#\\s].*\n)(?!\\2([ \n]|\\Z))", "$1$2$3$2\n");
        Matcher matcher = _sqlPattern1.matcher(content = content.replaceAll("(\\A|(?<!\\\\)\n)( *[\\w.-]+)(( +=)|(= +))(.*)(\\Z|\n)", "$1$2=$6$7"));
        if (matcher.find()) {
            String match = matcher.group();
            String indent = matcher.group(1);
            String sqlClause = matcher.group(3);
            sqlClause = sqlClause.replaceAll(" AND (?=\\()", " AND \\\\\n");
            sqlClause = sqlClause.replaceAll(" OR (?=\\()", " OR \\\\\n");
            sqlClause = sqlClause.replaceAll("\\((?=\\()", "(\\\\\n");
            sqlClause = sqlClause.replaceAll("\\)(?=\\))", ")\\\\\n");
            String[] sqlClauses = sqlClause.split("\n");
            String replacement = StringBundler.concat(indent, matcher.group(2), "\\\n", this._formatSQLClause(indent + "    ", sqlClauses));
            return StringUtil.replaceFirst(content, match, replacement, matcher.start());
        }
        matcher = _sqlPattern2.matcher(content);
        while (matcher.find()) {
            String sqlClause;
            String nextSQLClause;
            int lineNumber = this.getLineNumber(content, matcher.start());
            if (Validator.isNull(matcher.group(4)) || (nextSQLClause = this._getSQLClause(SourceUtil.getLine(content, lineNumber + 1))) == null || (sqlClause = matcher.group(1)).compareTo(nextSQLClause) <= 0) continue;
            content = StringUtil.replaceFirst(content, nextSQLClause, sqlClause, this.getLineStartPos(content, lineNumber + 1));
            return StringUtil.replaceFirst(content, sqlClause, nextSQLClause, this.getLineStartPos(content, lineNumber));
        }
        return content;
    }

    private String _formatSQLClause(String indent, String[] sqlClauses) {
        StringBundler sb = new StringBundler(sqlClauses.length * 3);
        for (String sqlClause : sqlClauses) {
            if (sqlClause.startsWith(")")) {
                indent = indent.substring(4);
            }
            sb.append(indent);
            sb.append(sqlClause);
            sb.append("\n");
            if (!sqlClause.equals("(\\")) continue;
            indent = indent + "    ";
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private String _getSQLClause(String line) {
        Matcher matcher = _sqlPattern2.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

