/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import java.io.File;
import java.util.List;

public class BNDLiferayRelengBundleCheck
extends BaseFileCheck {
    private static final String _ALLOWED_LIFERAY_RELENG_BUNDLE_NAMES = "allowedLiferayRelengBundleNames";

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.endsWith("/app.bnd") || !absolutePath.contains("/modules/dxp/apps/")) {
            return content;
        }
        List<String> allowedLiferayRelengBundleNames = this.getAttributeValues(_ALLOWED_LIFERAY_RELENG_BUNDLE_NAMES, absolutePath);
        for (String allowedLiferayRelengBundleName : allowedLiferayRelengBundleNames) {
            if (!absolutePath.contains(allowedLiferayRelengBundleName)) continue;
            return content;
        }
        String liferayRelengBundle = BNDSourceUtil.getDefinitionValue(content, "Liferay-Releng-Bundle");
        if (Validator.isNull(liferayRelengBundle) || liferayRelengBundle.equals("false")) {
            return content;
        }
        int pos = absolutePath.lastIndexOf("/");
        File file = new File(absolutePath.substring(0, pos + 1) + ".lfrbuild-release-src");
        if (!file.exists()) {
            this.addMessage(fileName, StringBundler.concat("DXP modules that have a 'app.bnd' file that contains ", "'Liferay-Releng-Bundle: true' should have a ", "'.lfrbuild-release-src' file"));
        }
        return content;
    }
}

