/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaConstructorParametersCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaSignature signature = javaTerm.getSignature();
        List<JavaParameter> parameters = signature.getParameters();
        if (!parameters.isEmpty()) {
            this._checkConstructorParameterOrder(fileName, javaTerm, parameters);
        }
        if (parameters.size() > 1) {
            return this._fixIncorrectEmptyLines(javaTerm.getContent(), parameters);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR};
    }

    private void _checkConstructorParameterOrder(String fileName, JavaTerm javaTerm, List<JavaParameter> parameters) {
        String previousGlobalVariableName = null;
        String previousParameterName = null;
        int previousPos = -1;
        for (JavaParameter parameter : parameters) {
            String beforeParameter;
            String parameterName = parameter.getParameterName();
            Pattern pattern = Pattern.compile(StringBundler.concat("\\{\n([\\s\\S]*?)((_|this\\.)", parameterName, ") =[ \t\n]+", parameterName, ";"));
            Matcher matcher = pattern.matcher(javaTerm.getContent());
            if (!matcher.find() || (beforeParameter = matcher.group(1)).contains(parameterName + " =")) continue;
            int pos = matcher.start(2);
            if (previousPos > pos && previousGlobalVariableName.startsWith(matcher.group(3))) {
                this.addMessage(fileName, StringBundler.concat("'", previousGlobalVariableName, " = ", previousParameterName, ";' should come before '", matcher.group(2), " = ", parameterName, ";' to match order of constructor parameters"), javaTerm.getLineNumber(previousPos));
                return;
            }
            previousGlobalVariableName = matcher.group(2);
            previousParameterName = parameterName;
            previousPos = pos;
        }
    }

    private String _fixIncorrectEmptyLines(String content, List<JavaParameter> parameters) {
        for (int i = 1; i < parameters.size(); ++i) {
            JavaParameter parameter = parameters.get(i);
            JavaParameter previousParameter = parameters.get(i - 1);
            String name = parameter.getParameterName();
            String previousName = previousParameter.getParameterName();
            Pattern pattern = Pattern.compile(StringBundler.concat("\t_", previousName, " =[ \t\n]+", previousName, ";(\n\n)\t+_", name, " =[ \t\n]+", name, ";\n"));
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find() || this._getOccurenceCount(content, name) != 2 || this._getOccurenceCount(content, "_" + name) != 1 || this._getOccurenceCount(content, previousName) != 2 || this._getOccurenceCount(content, "_" + previousName) != 1) continue;
            return StringUtil.replaceFirst(content, "\n", "", matcher.start(1));
        }
        return content;
    }

    private int _getOccurenceCount(String content, String name) {
        int count = 0;
        Pattern pattern = Pattern.compile("\\W" + name + "\\W");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }
}

