/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.PropertyValueComparator;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesMultiLineValuesOrderCheck
extends BaseFileCheck {
    private static final Pattern _keyValuesPattern = Pattern.compile("(\n|\\A)( *).+=\\\\(\n\\2    .+){2,}");
    private static final Pattern _multiLineValuesPattern = Pattern.compile("(\n +(?![\\\\# ]).*){2,}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        if (!shortFileName.matches("(ci|compatibility|system(-ext)?|test)\\.properties")) {
            return content;
        }
        return this._sortValues(content);
    }

    private String _sortValues(String content) throws IOException {
        Matcher matcher1 = _keyValuesPattern.matcher(content);
        block0: while (matcher1.find()) {
            String match = matcher1.group();
            Matcher matcher2 = _multiLineValuesPattern.matcher(match);
            while (matcher2.find()) {
                String originalValues;
                String s = originalValues = matcher2.group();
                if (originalValues.endsWith("\\") && !originalValues.endsWith(",\\")) {
                    s = StringUtil.replaceLast(s, '\\', "");
                }
                List<String> valuesList = ListUtil.fromArray(s.split(",\\\\"));
                if (StringUtil.count(originalValues, "\n") != valuesList.size()) continue block0;
                Collections.sort(valuesList, new PropertyValueComparator());
                String newValues = this._splitValues(originalValues, valuesList);
                if (originalValues.equals(newValues)) continue;
                return StringUtil.replaceFirst(content, originalValues, newValues, matcher1.start());
            }
        }
        return content;
    }

    private String _splitValues(String originalValues, List<String> valuesList) {
        StringBundler sb = new StringBundler(valuesList.size() * 2);
        for (String value : valuesList) {
            sb.append(value);
            sb.append(",\\");
        }
        if (!originalValues.endsWith(",\\")) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

