/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.parser.BaseJavaTerm;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.List;

public class JavaClass
extends BaseJavaTerm {
    private final boolean _anonymous;
    private final List<JavaTerm> _childJavaTerms = new ArrayList<JavaTerm>();
    private List<String> _extendedClassNames = new ArrayList<String>();
    private List<String> _implementedClassNames = new ArrayList<String>();
    private List<String> _imports = new ArrayList<String>();
    private final boolean _isInterface;
    private String _packageName;

    public JavaClass(String name, String content, String accessModifier, int lineNumber, boolean isAbstract, boolean isFinal, boolean isStatic, boolean isInterface, boolean anonymous) {
        super(name, content, accessModifier, lineNumber, isAbstract, isFinal, isStatic);
        this._isInterface = isInterface;
        this._anonymous = anonymous;
    }

    public void addChildJavaTerm(JavaTerm javaTerm) {
        javaTerm.setParentJavaClass(this);
        this._childJavaTerms.add(javaTerm);
    }

    public void addExtendedClassNames(String ... extendedClassNames) {
        for (String extendedClassName : extendedClassNames) {
            this._extendedClassNames.add(StringUtil.trim(extendedClassName));
        }
    }

    public void addImplementedClassNames(String ... implementedClassNames) {
        for (String implementedClassName : implementedClassNames) {
            this._implementedClassNames.add(StringUtil.trim(implementedClassName));
        }
    }

    public void addImport(String importName) {
        this._imports.add(importName);
    }

    public List<JavaTerm> getChildJavaTerms() {
        return this._childJavaTerms;
    }

    public List<String> getExtendedClassNames() {
        return this.getExtendedClassNames(false);
    }

    public List<String> getExtendedClassNames(boolean fullyQualifiedClassName) {
        if (!fullyQualifiedClassName || this._extendedClassNames.isEmpty()) {
            return this._extendedClassNames;
        }
        return this._getFullyQualifiedClassNames(this._extendedClassNames);
    }

    public List<String> getImplementedClassNames() {
        return this.getImplementedClassNames(false);
    }

    public List<String> getImplementedClassNames(boolean fullyQualifiedClassName) {
        if (!fullyQualifiedClassName || this._implementedClassNames.isEmpty()) {
            return this._implementedClassNames;
        }
        return this._getFullyQualifiedClassNames(this._implementedClassNames);
    }

    public List<String> getImports() {
        return this._imports;
    }

    public String getName(boolean fullyQualifiedClassName) {
        if (!fullyQualifiedClassName) {
            return this.getName();
        }
        return this._packageName + "." + this.getName();
    }

    public String getPackageName() {
        return this._packageName;
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public boolean isInterface() {
        return this._isInterface;
    }

    public void setPackageName(String packageName) {
        this._packageName = packageName;
    }

    private List<String> _getFullyQualifiedClassNames(List<String> classNames) {
        ArrayList<String> fullyQualifiedClassNames = new ArrayList<String>();
        block0: for (String className : classNames) {
            if (className.matches("([a-z]\\w*\\.){2,}[A-Z]\\w*")) {
                fullyQualifiedClassNames.add(className);
                continue;
            }
            for (String importName : this._imports) {
                if (!importName.endsWith("." + className)) continue;
                fullyQualifiedClassNames.add(importName);
                continue block0;
            }
            fullyQualifiedClassNames.add(this._packageName + "." + className);
        }
        return fullyQualifiedClassNames;
    }
}

