/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseJSPTermsCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPUnusedTermsCheck
extends BaseJSPTermsCheck {
    private static final String[] _PORTLET_DEFINE_OBJECTS_PROPERTIES = new String[]{"actionRequest", "actionResponse", "eventRequest", "eventResponse", "liferayPortletRequest", "liferayPortletResponse", "portletConfig", "portletName", "portletPreferences", "portletPreferencesValues", "portletSession", "portletSessionScope", "renderResponse", "renderRequest", "resourceRequest", "resourceResponse"};
    private static final String _UNUSED_VARIABLES_EXCLUDES = "jsp.unused.variables.excludes";
    private static final Pattern _compressedJSPImportPattern = Pattern.compile("(<.*\n*(?:page|tag) import=\".*>\n*)+", 8);
    private static final Pattern _compressedJSPTaglibPattern = Pattern.compile("(<.*\n*taglib uri=\".*>\n*)+", 8);
    private static final Pattern _defineObjectsPattern = Pattern.compile("<[\\w-]+:defineObjects />");
    private static final Pattern _variableDeclarationPattern = Pattern.compile("^([\\w<>,\\s]+?)\\s(\\w+)( =\\s|;)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        this.populateContentsMap(fileName, content);
        content = this._removeUnusedImports(fileName, content);
        content = JSPSourceUtil.compressImportsOrTaglibs(fileName, content, "<%@ page import=");
        content = JSPSourceUtil.compressImportsOrTaglibs(fileName, content, "<%@ tag import=");
        if (this.isPortalSource() || this.isSubrepository()) {
            content = this._removeUnusedPortletDefineObjects(fileName, content);
            content = this._removeDuplicateDefineObjects(fileName, content);
            content = this._removeUnusedTaglibs(fileName, content);
            content = JSPSourceUtil.compressImportsOrTaglibs(fileName, content, "<%@ taglib uri=");
            content = this._removeUnusedVariables(fileName, absolutePath, content);
        }
        this.put(fileName, content);
        return content;
    }

    private void _addJSPUnusedImports(String fileName, String content, List<String> importLines, List<String> unneededImports) {
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        for (String importLine : importLines) {
            int x = importLine.indexOf(34);
            int y = importLine.indexOf(34, x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            className = className.substring(className.lastIndexOf(46) + 1);
            if (!this.hasUnusedJSPTerm(fileName, content, "\\W" + className + "[^\\w\"]", "class", checkedFileNames, includeFileNames, this.getContentsMap())) continue;
            unneededImports.add(importLine);
        }
    }

    private void _addJSPUnusedTaglibs(String fileName, String content, List<String> taglibLines, List<String> unneededTaglibs) {
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        for (String taglibLine : taglibLines) {
            int x = taglibLine.indexOf("prefix=\"");
            int y = taglibLine.indexOf(34, x + 8);
            if (x == -1 || y == -1) continue;
            String prefix = taglibLine.substring(x + 8, y);
            String regex = StringBundler.concat("<", prefix, ":", "|", "\\$\\{", prefix, ":");
            if (!this.hasUnusedJSPTerm(fileName, content, regex, "taglib", checkedFileNames, includeFileNames, this.getContentsMap())) continue;
            unneededTaglibs.add(taglibLine);
        }
    }

    private List<String> _getJSPDuplicateImports(String fileName, String content, List<String> importLines) {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 && (y = content.indexOf("<%@ tag import=")) == -1 || x >= y || !this._isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    private List<String> _getJSPDuplicateTaglibs(String fileName, String content, List<String> taglibLines) {
        ArrayList<String> duplicateTaglibs = new ArrayList<String>();
        for (String taglibLine : taglibLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ taglib uri=")) == -1 || x >= y || !this._isJSPDuplicateTaglib(fileName, taglibLine, false)) continue;
            duplicateTaglibs.add(taglibLine);
        }
        return duplicateTaglibs;
    }

    private String _getVariableName(String line) {
        Matcher matcher = _variableDeclarationPattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String typeName = matcher.group(1);
        if (!(typeName.equals("break") || typeName.equals("continue") || typeName.equals("return") || typeName.equals("throw"))) {
            return matcher.group(2);
        }
        return null;
    }

    private boolean _hasUnusedPortletDefineObjectsProperty(String fileName, String content, String portletDefineObjectProperty, Set<String> checkedFileNames, Set<String> includeFileNames) {
        return this.hasUnusedJSPTerm(fileName, content, "\\W" + portletDefineObjectProperty + "\\W", "portletDefineObjectProperty", checkedFileNames, includeFileNames, this.getContentsMap());
    }

    private boolean _hasUnusedVariable(String fileName, String content, String line, int lineNumber, Set<String> checkedFileNames, Set<String> includeFileNames) {
        String variableName = this._getVariableName(line);
        if (variableName == null) {
            return false;
        }
        return this.hasUnusedJSPTerm(fileName, content, "\\W" + variableName + "\\W", lineNumber, "variable", checkedFileNames, includeFileNames, this.getContentsMap());
    }

    private boolean _isJSPDuplicateDefineObjects(String fileName, String defineObjects, boolean checkFile) {
        Map<String, String> contentsMap = this.getContentsMap();
        String content = contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        if (checkFile && content.contains(defineObjects)) {
            return true;
        }
        int x = content.indexOf("<%@ include file=");
        if (x == -1) {
            return false;
        }
        if ((x = content.indexOf(34, x)) == -1) {
            return false;
        }
        int y = content.indexOf(34, x + 1);
        if (y == -1) {
            return false;
        }
        String includeFileName = content.substring(x + 1, y);
        includeFileName = JSPSourceUtil.buildFullPathIncludeFileName(fileName, includeFileName, this.getContentsMap());
        return this._isJSPDuplicateDefineObjects(includeFileName, defineObjects, true);
    }

    private boolean _isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) {
        Map<String, String> contentsMap = this.getContentsMap();
        String content = contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1 && (x = importLine.indexOf("tag")) == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf(34, y)) == -1) {
            return false;
        }
        int z = content.indexOf(34, y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        includeFileName = JSPSourceUtil.buildFullPathIncludeFileName(fileName, includeFileName, this.getContentsMap());
        return this._isJSPDuplicateImport(includeFileName, importLine, true);
    }

    private boolean _isJSPDuplicateTaglib(String fileName, String taglibLine, boolean checkFile) {
        Map<String, String> contentsMap = this.getContentsMap();
        String content = contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        int x = taglibLine.indexOf("taglib");
        if (x == -1) {
            return false;
        }
        if (checkFile && content.contains(taglibLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf(34, y)) == -1) {
            return false;
        }
        int z = content.indexOf(34, y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        includeFileName = JSPSourceUtil.buildFullPathIncludeFileName(fileName, includeFileName, this.getContentsMap());
        return this._isJSPDuplicateTaglib(includeFileName, taglibLine, true);
    }

    private String _removeDuplicateDefineObjects(String fileName, String content) {
        Matcher matcher = _defineObjectsPattern.matcher(content);
        while (matcher.find()) {
            if (!this._isJSPDuplicateDefineObjects(fileName, matcher.group(), false)) continue;
            return StringUtil.replaceFirst(content, matcher.group(), "", matcher.start());
        }
        return content;
    }

    private String _removeUnusedImports(String fileName, String content) throws IOException {
        if (fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = _compressedJSPImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        String newImports = StringUtil.replace(imports, new String[]{"<%@\r\n", "<%@\n", " %><%@ "}, new String[]{"\r\n<%@ ", "\n<%@ ", " %>\n<%@ "});
        ArrayList<String> importLines = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(newImports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import=")) continue;
            importLines.add(line);
        }
        List<String> unneededImports = this._getJSPDuplicateImports(fileName, content, importLines);
        this._addJSPUnusedImports(fileName, content, importLines, unneededImports);
        for (String unneededImport : unneededImports) {
            newImports = StringUtil.removeSubstring(newImports, unneededImport);
        }
        return StringUtil.replaceFirst(content, imports, newImports);
    }

    private String _removeUnusedPortletDefineObjects(String fileName, String content) {
        if (!content.contains("<portlet:defineObjects />\n")) {
            return content;
        }
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        for (String portletDefineObjectProperty : _PORTLET_DEFINE_OBJECTS_PROPERTIES) {
            if (this._hasUnusedPortletDefineObjectsProperty(fileName, content, portletDefineObjectProperty, checkedFileNames, includeFileNames)) continue;
            return content;
        }
        return StringUtil.removeSubstring(content, "<portlet:defineObjects />");
    }

    private String _removeUnusedTaglibs(String fileName, String content) throws IOException {
        if (fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = _compressedJSPTaglibPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String taglibs = matcher.group();
        String newTaglibs = StringUtil.replace(taglibs, new String[]{"<%@\r\n", "<%@\n", " %><%@ "}, new String[]{"\r\n<%@ ", "\n<%@ ", " %>\n<%@ "});
        ArrayList<String> taglibLines = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(newTaglibs));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("uri=")) continue;
            taglibLines.add(line);
        }
        List<String> unneededTaglibs = this._getJSPDuplicateTaglibs(fileName, content, taglibLines);
        this._addJSPUnusedTaglibs(fileName, content, taglibLines, unneededTaglibs);
        for (String unneededTaglib : unneededTaglibs) {
            newTaglibs = StringUtil.removeSubstring(newTaglibs, unneededTaglib);
        }
        return StringUtil.replaceFirst(content, taglibs, newTaglibs);
    }

    private String _removeUnusedVariables(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.contains("/src/main/resources/alloy_mvc/jsp/") && absolutePath.endsWith(".jspf")) {
            return content;
        }
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            boolean javaSource = false;
            boolean unusedVariable = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                }
                if (javaSource && !this.isExcludedPath(_UNUSED_VARIABLES_EXCLUDES, absolutePath, lineNumber) && this._hasUnusedVariable(fileName, content, trimmedLine, lineNumber, checkedFileNames, includeFileNames)) {
                    unusedVariable = true;
                }
                if (unusedVariable) {
                    if (!trimmedLine.endsWith(";")) continue;
                    unusedVariable = false;
                    continue;
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

