/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class JSONPackageJSONDependencyVersionCheck
extends BaseFileCheck {
    private Map<String, String> _expectedDependencyVersionsMap;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/package.json") || !absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/dxp/apps/") && !absolutePath.contains("/modules/private/apps/")) {
            return content;
        }
        return this._fixDependencyVersions(absolutePath, content);
    }

    private String _fixDependencyVersions(String absolutePath, String content) throws IOException {
        JSONObject jsonObject = new JSONObject(content);
        if (jsonObject.isNull("dependencies")) {
            return content;
        }
        Map<String, String> expectedDependencyVersionsMap = this._getExpectedDependencyVersionsMap(absolutePath);
        JSONObject dependenciesJSONObject = jsonObject.getJSONObject("dependencies");
        Iterator iterator = dependenciesJSONObject.keys();
        while (iterator.hasNext()) {
            String dependencyName = (String)iterator.next();
            String actualVersion = dependenciesJSONObject.getString(dependencyName);
            String expectedVersion = expectedDependencyVersionsMap.get(dependencyName);
            if (expectedVersion == null || expectedVersion.equals(actualVersion)) continue;
            content = StringUtil.replace(content, StringBundler.concat("\"", dependencyName, "\": \"", actualVersion, "\""), StringBundler.concat("\"", dependencyName, "\": \"", expectedVersion, "\""));
        }
        return content;
    }

    private Map<String, String> _getDependencyVersionsMap(String fileName, String absolutePath, String regex) throws IOException {
        HashMap<String, String> dependencyVersionsMap = new HashMap<String, String>();
        String content = this.getPortalContent(fileName, absolutePath);
        if (Validator.isNull(content)) {
            return dependencyVersionsMap;
        }
        JSONObject jsonObject = new JSONObject(content);
        JSONObject dependenciesJSONObject = jsonObject.getJSONObject("dependencies");
        Iterator iterator = dependenciesJSONObject.keys();
        while (iterator.hasNext()) {
            String dependencyName = (String)iterator.next();
            if (!dependencyName.matches(regex)) continue;
            dependencyVersionsMap.put(dependencyName, dependenciesJSONObject.getString(dependencyName));
        }
        return dependencyVersionsMap;
    }

    private synchronized Map<String, String> _getExpectedDependencyVersionsMap(String absolutePath) throws IOException {
        if (this._expectedDependencyVersionsMap != null) {
            return this._expectedDependencyVersionsMap;
        }
        this._expectedDependencyVersionsMap = HashMapBuilder.putAll(this._getDependencyVersionsMap("modules/apps/frontend-js/frontend-js-metal-web/package.json", absolutePath, "metal(-.*)?")).putAll(this._getDependencyVersionsMap("modules/apps/frontend-js/frontend-js-react-web/package.json", absolutePath, ".*")).putAll(this._getDependencyVersionsMap("modules/apps/frontend-js/frontend-js-spa-web/package.json", absolutePath, "senna")).putAll(this._getDependencyVersionsMap("modules/apps/frontend-taglib/frontend-taglib-clay/package.json", absolutePath, "clay-.*")).putAll(this._getDependencyVersionsMap("modules/apps/frontend-taglib/frontend-taglib-clay/package.json", absolutePath, "@clayui/.*")).build();
        String content = this.getModulesPropertiesContent(absolutePath);
        if (Validator.isNull(content)) {
            return this._expectedDependencyVersionsMap;
        }
        List<String> lines = ListUtil.fromString(content);
        for (String line : lines) {
            String key;
            String[] array = StringUtil.split(line, "=");
            if (array.length != 2 || !(key = array[0]).startsWith("bundle.symbolic.name[")) continue;
            this._expectedDependencyVersionsMap.put(key.substring(21, key.length() - 1), "*");
        }
        return this._expectedDependencyVersionsMap;
    }
}

