/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPIndentationCheck
extends BaseFileCheck {
    private static final Pattern _javaSourcePattern1 = Pattern.compile("\n(\t*)(<%\n(\t*[^\t%].*?))\n(\t*)%>\n", 32);
    private static final Pattern _javaSourcePattern2 = Pattern.compile("\n(\t*)([^\t\n]+[\"']<%=\n(\t*[^\t%].*?))\n\t*%>[\"']\n", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!(fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".tag"))) {
            return content;
        }
        String originalContent = content;
        String newContent;
        while (!(newContent = this._formatTabs(content, originalContent)).equals(content) && !newContent.equals(originalContent)) {
            content = newContent;
        }
        return newContent;
    }

    private int _calculateTabLevel(String text, boolean javaSource) {
        if (javaSource) {
            return this.getLevel(text, new String[]{"{", "("}, new String[]{"}", ")"});
        }
        if (text.matches("(--)?%>")) {
            return -1;
        }
        text = this._stripJavaSource(text);
        text = this.stripQuotes(text);
        int level = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                if (i + 1 < text.length() && text.charAt(i + 1) == '!') continue;
                if (i + 1 < text.length() && text.charAt(i + 1) == '/') {
                    --level;
                    continue;
                }
                ++level;
                continue;
            }
            if (c == '>' && i > 0 && text.charAt(i - 1) == '/') {
                --level;
                continue;
            }
            if (c == '{') {
                ++level;
                continue;
            }
            if (c != '}') continue;
            --level;
        }
        return level;
    }

    private String _fixTabs(String content, int lineNumber, int diff) {
        return this._fixTabs(content, lineNumber, lineNumber, diff);
    }

    private String _fixTabs(String content, int startLine, int endLine, int diff) {
        boolean insideUnformattedTextTag = false;
        for (int i = startLine; i <= endLine; ++i) {
            String line = this.getLine(content, i);
            if (Validator.isNull(line) || this.getLeadingTabCount(line) < diff) continue;
            String trimmedLine = StringUtil.trimLeading(line);
            if (insideUnformattedTextTag) {
                if (!trimmedLine.matches(".*</(pre|textarea)>")) continue;
                insideUnformattedTextTag = false;
                if (trimmedLine.matches(".+</(pre|textarea)>")) continue;
            }
            int lineStartPos = this.getLineStartPos(content, i);
            content = diff < 0 ? content.substring(0, lineStartPos) + "\t" + content.substring(lineStartPos) : content.substring(0, lineStartPos) + content.substring(lineStartPos + 1);
            if (insideUnformattedTextTag || !trimmedLine.matches("<(pre|textarea).*")) continue;
            insideUnformattedTextTag = true;
        }
        return content;
    }

    private String _fixTabsInJavaSource(String content) {
        int minimumTabCount;
        String tabs;
        Matcher matcher = _javaSourcePattern1.matcher(content);
        while (matcher.find()) {
            tabs = matcher.group(1);
            minimumTabCount = this._getMinimumTabCount(matcher.group(2));
            if (tabs.length() != minimumTabCount) {
                int diff = minimumTabCount - tabs.length();
                int end = this.getLineNumber(content, matcher.end(2));
                int start = this.getLineNumber(content, matcher.start(3));
                return this._fixTabs(content, start, end, diff);
            }
            String javaCloseTagTabs = matcher.group(4);
            if (tabs.equals(javaCloseTagTabs)) continue;
            int diff = javaCloseTagTabs.length() - tabs.length();
            return this._fixTabs(content, this.getLineNumber(content, matcher.end(4)), diff);
        }
        matcher = _javaSourcePattern2.matcher(content);
        while (matcher.find()) {
            tabs = matcher.group(1);
            minimumTabCount = this._getMinimumTabCount(matcher.group(2));
            if (tabs.length() + 1 == minimumTabCount) continue;
            int diff = minimumTabCount - (tabs.length() + 1);
            int end = this.getLineNumber(content, matcher.end(2));
            int start = this.getLineNumber(content, matcher.start(3));
            return this._fixTabs(content, start, end, diff);
        }
        return content;
    }

    private String _formatTabs(String content, String originalContent) throws IOException {
        List<JSPLine> jspLines = this._getJSPLines(content);
        if (jspLines == null) {
            return originalContent;
        }
        for (int i = 0; i < jspLines.size(); ++i) {
            JSPLine jspLine = jspLines.get(i);
            if (jspLine.isCloseTag()) {
                if (jspLine.isClosed()) continue;
                return originalContent;
            }
            String line = jspLine.getLine();
            if (!jspLine.isOpenTag()) {
                if (jspLine.isJavaSource()) continue;
                int actualTabCount = jspLine.getLeadingTabCount();
                int expectedTabCount = jspLine.getTabLevel();
                String trimmedLine = StringUtil.trim(line);
                if (trimmedLine.equals(">")) {
                    --expectedTabCount;
                }
                if (expectedTabCount == actualTabCount) continue;
                return this._fixTabs(content, jspLine.getLineNumber(), actualTabCount - expectedTabCount);
            }
            JSPLine closeTagJSPLine = this._getCloseTagJSPLine(jspLine, jspLines, i);
            if (closeTagJSPLine == null) {
                return originalContent;
            }
            String closeTagName = closeTagJSPLine.getTagName();
            String openTagName = jspLine.getTagName();
            if (Validator.isNotNull(closeTagName) && !closeTagName.equals(openTagName)) {
                return originalContent;
            }
            int expectedTabCount = this._getExpectedTabCount(jspLine, closeTagJSPLine, jspLines, i);
            int actualCloseTagTabCount = closeTagJSPLine.getLeadingTabCount();
            int actualOpenTagTabCount = jspLine.getLeadingTabCount();
            if (expectedTabCount != actualOpenTagTabCount) {
                int diff = actualOpenTagTabCount - expectedTabCount;
                if (actualOpenTagTabCount == actualCloseTagTabCount) {
                    return this._fixTabs(content, jspLine.getLineNumber(), closeTagJSPLine.getLineNumber(), diff);
                }
                return this._fixTabs(content, jspLine.getLineNumber(), diff);
            }
            if (expectedTabCount != actualCloseTagTabCount) {
                return this._fixTabs(content, closeTagJSPLine.getLineNumber(), actualCloseTagTabCount - expectedTabCount);
            }
            closeTagJSPLine.setClosed(true);
        }
        return this._fixTabsInJavaSource(content);
    }

    private JSPLine _getCloseTagJSPLine(JSPLine openTagJSPLine, List<JSPLine> jspLines, int index) {
        String line;
        String openTagLine;
        JSPLine jspLine;
        do {
            if (++index < jspLines.size()) continue;
            return null;
        } while (!(jspLine = jspLines.get(index)).isCloseTag() || !((openTagLine = openTagJSPLine.getLine()).matches("\t*<%!?") ? (line = jspLine.getLine()).matches("\t*%>") : jspLine.isCloseTag() && openTagJSPLine.getTabLevel() == jspLine.getLineTabLevel() + jspLine.getTabLevel()));
        return jspLine;
    }

    private int _getExpectedTabCount(JSPLine startTagJSPLine, JSPLine closeTagJSPLine, List<JSPLine> jspLines, int index) {
        JSPLine jspLine;
        String startTagLine = startTagJSPLine.getLine();
        if (!startTagLine.matches("\t*<%!?")) {
            return startTagJSPLine.getTabLevel();
        }
        int minJavaSourceLevel = startTagJSPLine.getTabLevel();
        do {
            jspLine = jspLines.get(++index);
            minJavaSourceLevel = Math.min(minJavaSourceLevel, jspLine.getTabLevel() - 1);
        } while (!jspLine.equals(closeTagJSPLine));
        return minJavaSourceLevel;
    }

    private List<JSPLine> _getJSPLines(String content) throws IOException {
        ArrayList<JSPLine> jspLines = new ArrayList<JSPLine>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineNumber = 0;
            int tabLevel = 0;
            boolean javaSource = false;
            boolean scriptSource = false;
            boolean multiLineComment = false;
            boolean insideUnformattedTextTag = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ArrayList<JSPLine> arrayList;
                String trimmedLine;
                ++lineNumber;
                if (Validator.isNull(line) || (trimmedLine = StringUtil.trimLeading(line)).matches("(<%@ )?(page import|tag import|taglib uri)=.*")) continue;
                if (javaSource) {
                    if (trimmedLine.matches("%>[\"']?")) {
                        javaSource = false;
                    } else if (trimmedLine.startsWith("/*") && !trimmedLine.startsWith("/**")) {
                        multiLineComment = true;
                        continue;
                    }
                    if (line.endsWith("*/")) {
                        multiLineComment = false;
                        continue;
                    }
                    if (multiLineComment || trimmedLine.startsWith("*") || trimmedLine.startsWith("/*") || trimmedLine.startsWith("//")) continue;
                }
                int lineTabLevel = this._calculateTabLevel(trimmedLine, javaSource);
                if (!javaSource && !scriptSource && line.endsWith("--%>")) {
                    multiLineComment = false;
                }
                if (insideUnformattedTextTag) {
                    if (!trimmedLine.matches(".*</(pre|textarea)>")) continue;
                    insideUnformattedTextTag = false;
                    if (trimmedLine.matches(".+</(pre|textarea)>")) continue;
                }
                if (scriptSource) {
                    if (!trimmedLine.matches("</(aui:)?script>")) continue;
                    scriptSource = false;
                }
                if (trimmedLine.equals("AUI.add(")) {
                    arrayList = jspLines;
                    return arrayList;
                }
                if (!multiLineComment) {
                    if (!javaSource && Math.abs(lineTabLevel) > 1) {
                        arrayList = null;
                        return arrayList;
                    }
                    JSPLine jspLine = new JSPLine(line, lineNumber, tabLevel, lineTabLevel, javaSource);
                    jspLines.add(jspLine);
                }
                if (!javaSource && (trimmedLine.matches("<%!?") || trimmedLine.matches(".*[\"']<%="))) {
                    javaSource = true;
                } else if (!multiLineComment) {
                    if (trimmedLine.matches("<(aui:)?script.*") && lineTabLevel > 0) {
                        scriptSource = true;
                    } else if (trimmedLine.startsWith("<%--") && !line.endsWith("--%>")) {
                        multiLineComment = true;
                    } else if (trimmedLine.matches("<(pre|textarea).*") && !trimmedLine.matches(".*</(pre|textarea)>")) {
                        insideUnformattedTextTag = true;
                        continue;
                    }
                }
                tabLevel += lineTabLevel;
            }
        }
        return jspLines;
    }

    private int _getLeadingTabCount(String line) {
        return this.getLeadingTabCount(line);
    }

    private int _getMinimumTabCount(String s) {
        int minimumTabCount = -1;
        String[] lines = StringUtil.splitLines(s);
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            if (Validator.isNull(line)) continue;
            int tabCount = this.getLeadingTabCount(line);
            if (minimumTabCount != -1 && tabCount >= minimumTabCount) continue;
            minimumTabCount = tabCount;
        }
        return minimumTabCount;
    }

    private String _stripJavaSource(String text) {
        int x;
        while ((x = text.indexOf("<%")) != -1) {
            int y = text.indexOf("%>", x);
            if (y == -1) {
                return text;
            }
            text = text.substring(0, x) + text.substring(y + 2);
        }
        return text;
    }

    private class JSPLine {
        private boolean _closed;
        private final Pattern _closeTagNamePattern = Pattern.compile("</([\\-:\\w]+?)>");
        private final boolean _javaSource;
        private final String _line;
        private final int _lineNumber;
        private int _lineTabLevel;
        private final Pattern _openTagNamePattern = Pattern.compile("<([\\-:\\w]+?)([ >\n].*|$)");
        private final int _tabLevel;

        public JSPLine(String line, int lineNumber, int tabLevel, int lineTabLevel, boolean javaSource) {
            this._line = line;
            this._lineNumber = lineNumber;
            this._tabLevel = tabLevel;
            this._lineTabLevel = lineTabLevel;
            this._javaSource = javaSource;
        }

        public int getLeadingTabCount() {
            return JSPIndentationCheck.this._getLeadingTabCount(this._line);
        }

        public String getLine() {
            return this._line;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public int getLineTabLevel() {
            return this._lineTabLevel;
        }

        public int getTabLevel() {
            return this._tabLevel;
        }

        public String getTagName() {
            Matcher matcher = null;
            if (this.isCloseTag()) {
                matcher = this._closeTagNamePattern.matcher(this._line);
            } else if (this.isOpenTag()) {
                matcher = this._openTagNamePattern.matcher(this._line);
            } else {
                return null;
            }
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }

        public boolean isClosed() {
            return this._closed;
        }

        public boolean isCloseTag() {
            return !this._javaSource && this._lineTabLevel == -1;
        }

        public boolean isJavaSource() {
            return this._javaSource;
        }

        public boolean isOpenTag() {
            return !this._javaSource && this._lineTabLevel == 1 && this._line.matches("^\\s*<.*");
        }

        public void setClosed(boolean closed) {
            this._closed = closed;
        }
    }
}

