/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class SourceUtil {
    private static final String[] _ARTICLES = new String[]{"a", "an", "the"};
    private static final String[] _CONJUNCTIONS = new String[]{"and", "but", "for", "nor", "or", "yet"};
    private static final String[] _PREPOSITIONS = new String[]{"a", "abaft", "aboard", "about", "above", "absent", "across", "afore", "after", "against", "along", "alongside", "amid", "amidst", "among", "amongst", "an", "apropos", "apud", "around", "as", "aside", "astride", "at", "athwart", "atop", "barring", "before", "behind", "below", "beneath", "beside", "besides", "between", "beyond", "but", "by", "circa", "concerning", "despite", "down", "during", "except", "excluding", "failing", "for", "from", "given", "in", "including", "inside", "into", "lest", "mid", "midst", "modulo", "near", "next", "notwithstanding", "of", "off", "on", "onto", "opposite", "out", "outside", "over", "pace", "past", "per", "plus", "pro", "qua", "regarding", "sans", "since", "through", "throughout", "thru", "thruout", "till", "to", "toward", "towards", "under", "underneath", "unlike", "until", "unto", "up", "upon", "v", "versus", "via", "vice", "vs", "with", "within", "without", "worth"};

    public static boolean containsUnquoted(String s, String text) {
        int x = -1;
        do {
            if ((x = s.indexOf(text, x + 1)) != -1) continue;
            return false;
        } while (ToolsUtil.isInsideQuotes(s, x));
        return true;
    }

    public static String getAbsolutePath(File file) {
        return SourceUtil.getAbsolutePath(file.toPath());
    }

    public static String getAbsolutePath(Path filePath) {
        filePath = filePath.toAbsolutePath();
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    public static String getAbsolutePath(String fileName) {
        return SourceUtil.getAbsolutePath(Paths.get(fileName, new String[0]));
    }

    public static String getIndent(String s) {
        StringBundler sb = new StringBundler(s.length());
        for (int i = 0; i < s.length() && s.charAt(i) == '\t'; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }

    public static String getLine(String content, int lineNumber) {
        int nextLineStartPos = SourceUtil.getLineStartPos(content, lineNumber);
        if (nextLineStartPos == -1) {
            return null;
        }
        int nextLineEndPos = content.indexOf(10, nextLineStartPos);
        if (nextLineEndPos == -1) {
            return content.substring(nextLineStartPos);
        }
        return content.substring(nextLineStartPos, nextLineEndPos);
    }

    public static int getLineNumber(String content, int pos) {
        return StringUtil.count(content, 0, pos, '\n') + 1;
    }

    public static int getLineStartPos(String content, int lineNumber) {
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == 1) {
            return 0;
        }
        int x = -1;
        for (int i = 1; i < lineNumber; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    public static int[] getMultiLinePositions(String content, Pattern multiLinePattern) {
        ArrayList<Integer> multiLinePositions = new ArrayList<Integer>();
        Matcher matcher = multiLinePattern.matcher(content);
        while (matcher.find()) {
            multiLinePositions.add(SourceUtil.getLineNumber(content, matcher.start()));
            multiLinePositions.add(SourceUtil.getLineNumber(content, matcher.end() - 1));
        }
        return ArrayUtil.toIntArray(multiLinePositions);
    }

    public static String getRootDirName(String absolutePath) {
        int x;
        File file;
        do {
            if ((x = absolutePath.lastIndexOf(47)) != -1) continue;
            return "";
        } while (!(file = new File((absolutePath = absolutePath.substring(0, x)) + "/portal-impl")).exists());
        return absolutePath;
    }

    public static String getTitleCase(String s, boolean allowDash, String ... exceptions) {
        Object[] words;
        if (!allowDash) {
            s = StringUtil.replace(s, '-', ' ');
        }
        if (ArrayUtil.isEmpty(words = s.split("\\s+"))) {
            return s;
        }
        StringBundler sb = new StringBundler(words.length * 2);
        block0: for (int i = 0; i < words.length; ++i) {
            String lowerCaseWord;
            Object word = words[i];
            if (Validator.isNull((String)word)) continue;
            for (String exception : exceptions) {
                if (!StringUtil.equalsIgnoreCase(exception, (String)word)) continue;
                sb.append(exception);
                sb.append(' ');
                continue block0;
            }
            if (i != 0 && i != words.length && (ArrayUtil.contains(_ARTICLES, lowerCaseWord = StringUtil.toLowerCase((String)word)) || ArrayUtil.contains(_CONJUNCTIONS, lowerCaseWord) || ArrayUtil.contains(_PREPOSITIONS, lowerCaseWord))) {
                sb.append(lowerCaseWord);
                sb.append(' ');
                continue;
            }
            if (Character.isUpperCase(((String)word).charAt(0))) {
                sb.append((String)word);
            } else {
                sb.append(StringUtil.upperCaseFirstLetter((String)word));
            }
            sb.append(' ');
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static boolean hasTypo(String s1, String s2) {
        if (s1.charAt(0) != s2.charAt(0) || s1.charAt(s1.length() - 1) != s2.charAt(s2.length() - 1)) {
            return false;
        }
        int min = Math.min(s1.length(), s2.length());
        int diff = Math.abs(s1.length() - s2.length());
        if (min < 5 || diff > 1) {
            return false;
        }
        int i = StringUtil.startsWithWeight(s1, s2);
        if ((s1 = s1.substring(i)).startsWith("_")) {
            return false;
        }
        if ((s2 = s2.substring(i)).startsWith("_")) {
            return false;
        }
        int j = 1;
        while (j <= s1.length() && j <= s2.length()) {
            if (s1.charAt(s1.length() - j) != s2.charAt(s2.length() - j)) {
                char[] chars1 = s1.toCharArray();
                char[] chars2 = s2.toCharArray();
                Arrays.sort(chars1);
                Arrays.sort(chars2);
                return Arrays.equals(chars1, chars2);
            }
            ++j;
        }
        return true;
    }

    public static boolean isInsideMultiLines(int lineNumber, int[] multiLinePositions) {
        for (int i = 0; i < multiLinePositions.length - 1; i += 2) {
            if (lineNumber < multiLinePositions[i]) {
                return false;
            }
            if (lineNumber > multiLinePositions[i + 1]) continue;
            return true;
        }
        return false;
    }

    public static boolean isXML(String content) {
        try {
            SourceUtil.readXML(content);
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public static Document readXML(File file) throws DocumentException {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read(file);
    }

    public static Document readXML(String content) throws DocumentException {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read((Reader)new UnsyncStringReader(content));
    }
}

