/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClassNameCheck
extends BaseJavaTermCheck {
    private static final String _ENFORCE_IMPLEMENTED_CLASS_NAMES_KEY = "enforceImplementedClassNames";
    private static final String _EXPECTED_PACKAGE_PATH_DATA_KEY = "expectedPackagePathData";

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        if (javaTerm.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.isAnonymous() || javaClass.hasAnnotation("Deprecated")) {
            return javaTerm.getContent();
        }
        String className = javaClass.getName();
        String packageName = javaClass.getPackageName();
        this._checkTypo(fileName, className, packageName, 1);
        List<String> expectedPackagePathDataEntries = this.getAttributeValues(_EXPECTED_PACKAGE_PATH_DATA_KEY, absolutePath);
        for (String expectedPackagePathDataEntry : expectedPackagePathDataEntries) {
            String[] array = StringUtil.split(expectedPackagePathDataEntry, ':');
            if (array.length != 2) continue;
            String expectedClassNameEnding = array[1];
            if (!packageName.endsWith("." + array[0]) || className.endsWith(expectedClassNameEnding)) continue;
            this.addMessage(fileName, StringBundler.concat("Name of class in package '", packageName, "' should end with '", expectedClassNameEnding, "'"));
        }
        List<String> implementedClassNames = javaClass.getImplementedClassNames();
        if (implementedClassNames.isEmpty()) {
            return javaTerm.getContent();
        }
        List<String> enforceImplementedClassNames = this.getAttributeValues(_ENFORCE_IMPLEMENTED_CLASS_NAMES_KEY, absolutePath);
        for (String implementedClassName : enforceImplementedClassNames) {
            if (!implementedClassNames.contains(implementedClassName) || className.endsWith(implementedClassName)) continue;
            this.addMessage(fileName, StringBundler.concat("Name of class implementing '", implementedClassName, "' should end with '", implementedClassName, "'"));
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkTypo(String fileName, String className, String packageName, int level) {
        String[] packageNameParts;
        String packageNamePart;
        StringBundler sb = new StringBundler(level + 2);
        sb.append("(.*[a-z0-9]|\\A)");
        for (int i = 0; i < level; ++i) {
            sb.append("([A-Z][a-z0-9]+)");
        }
        sb.append("$");
        Pattern pattern = Pattern.compile(sb.toString());
        Matcher matcher = pattern.matcher(className);
        if (!matcher.find()) {
            return;
        }
        String classNamePart = StringUtil.toLowerCase(matcher.group(2));
        if (classNamePart.equals(packageNamePart = (packageNameParts = StringUtil.split(packageName, '.'))[packageNameParts.length - level])) {
            this._checkTypo(fileName, className, packageName, level + 1);
        } else if (SourceUtil.hasTypo(classNamePart, packageNamePart)) {
            this.addMessage(fileName, StringBundler.concat("Typo in either class name '", className, "' or package '", packageName, "'"));
        }
    }
}

