/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.IOException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLLookAndFeelCompatibilityVersionCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException, IOException {
        if (fileName.endsWith("-look-and-feel.xml")) {
            this._checkCompatibility(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkCompatibility(String fileName, String absolutePath, String content) throws DocumentException, IOException {
        if (!this.isPortalSource() || !this.isModulesApp(absolutePath, false)) {
            return;
        }
        boolean privateApp = this.isModulesApp(absolutePath, true);
        String portalVersion = this.getPortalVersion(privateApp);
        if (Validator.isNull(portalVersion)) {
            return;
        }
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List compatibilityElements = rootElement.elements("compatibility");
        for (Element compatibilityElement : compatibilityElements) {
            if (this._hasPortalVersions(compatibilityElement, portalVersion)) continue;
            StringBundler sb = new StringBundler(4);
            sb.append("Missing version: <version>");
            sb.append(portalVersion);
            sb.append("+");
            sb.append("</version>");
            this.addMessage(fileName, sb.toString());
        }
    }

    private boolean _hasPortalVersions(Element compatibilityElement, String portalVersion) {
        List versionElements = compatibilityElement.elements("version");
        for (Element versionElement : versionElements) {
            String version = versionElement.getText();
            if (!StringUtil.equalsIgnoreCase(version, portalVersion + "+")) continue;
            return true;
        }
        return false;
    }
}

