/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;

public class ResourceBundleCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
            return content;
        }
        int pos = content.indexOf("ResourceBundle.getBundle(");
        if (pos != -1) {
            this.addMessage(fileName, "Use ResourceBundleUtil.getBundle instead of ResourceBundle.getBundle", this.getLineNumber(content, pos));
        }
        if ((pos = content.indexOf("resourceBundle.getString(")) != -1) {
            this.addMessage(fileName, "Use ResourceBundleUtil.getString instead of resourceBundle.getString", this.getLineNumber(content, pos));
        }
        return content;
    }
}

