/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiWhitespaceCheck
extends WhitespaceCheck {
    private static final Pattern _incorrectCommandPattern = Pattern.compile("(\n\t*(function|macro|test))(?! \\w+ \\{)[\t ]+(\\w+)\\s*(\\{)");
    private static final Pattern _incorrectWhitespacePattern = Pattern.compile("\\)(\\s+);|(\n\t*)\\{");
    private static final Pattern _multiLineCommentsPattern = Pattern.compile("[ \t]/\\*.*?\\*/", 32);
    private static final Pattern _multiLineStringPattern = Pattern.compile("'''.*?'''", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatWhitespace(content);
        content = this._formatWhitespace(fileName, absolutePath, content);
        content = this._formatWhitespaceOnCommand(content);
        return super.doProcess(fileName, absolutePath, content);
    }

    private String _formatWhitespace(String content) {
        int[] multiLineCommentsPositions = SourceUtil.getMultiLinePositions(content, _multiLineCommentsPattern);
        int[] multiLineStringPositions = SourceUtil.getMultiLinePositions(content, _multiLineStringPattern);
        Matcher matcher = _incorrectWhitespacePattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group(1);
            int pos = matcher.start(1);
            if (pos == -1) {
                match = matcher.group(2);
                pos = matcher.start(2);
            }
            if (ToolsUtil.isInsideQuotes(content, pos) || SourceUtil.isInsideMultiLines(this.getLineNumber(content, pos), multiLineCommentsPositions) || SourceUtil.isInsideMultiLines(this.getLineNumber(content, pos), multiLineStringPositions)) continue;
            return StringUtil.replaceFirst(content, match, "", matcher.start());
        }
        return content;
    }

    private String _formatWhitespace(String fileName, String absolutePath, String content) throws IOException {
        int[] multiLineCommentsPositions = SourceUtil.getMultiLinePositions(content, _multiLineCommentsPattern);
        int[] multiLineStringPositions = SourceUtil.getMultiLinePositions(content, _multiLineStringPattern);
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                line = this.trimLine(fileName, absolutePath, line);
                if (SourceUtil.isInsideMultiLines(++lineNumber, multiLineCommentsPositions) || SourceUtil.isInsideMultiLines(lineNumber, multiLineStringPositions)) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                String trimmedLine = StringUtil.trimLeading(line);
                line = this.formatWhitespace(line, trimmedLine, false);
                line = this.formatIncorrectSyntax(line, "){", ") {", false);
                line = this.formatIncorrectSyntax(line, "for \\([^:]*[^:\"'\\s](:)");
                line = this.formatIncorrectSyntax(line, "for \\([^:]*:([^:\"'\\s])");
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String _formatWhitespaceOnCommand(String content) {
        int[] multiLineCommentsPositions = SourceUtil.getMultiLinePositions(content, _multiLineCommentsPattern);
        int[] multiLineStringPositions = SourceUtil.getMultiLinePositions(content, _multiLineStringPattern);
        Matcher matcher = _incorrectCommandPattern.matcher(content);
        while (matcher.find()) {
            int lineNumber = SourceUtil.getLineNumber(content, matcher.start());
            if (SourceUtil.isInsideMultiLines(lineNumber, multiLineCommentsPositions) || SourceUtil.isInsideMultiLines(lineNumber, multiLineStringPositions)) continue;
            return StringUtil.replaceFirst(content, matcher.group(), StringBundler.concat(matcher.group(1), " ", matcher.group(3), " ", matcher.group(4)), matcher.start());
        }
        return content;
    }
}

