/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJSPTermsCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPTaglibVariableCheck
extends BaseJSPTermsCheck {
    private static final Pattern _taglibVariablePattern = Pattern.compile("\n(\t*([\\w<>\\[\\],\\? ]+) (\\w+) = (((?!;\n).)*);)\n\\s*%>\\s+(<[\\S\\s]*?>)(\n|\\Z)", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        return this._formatTaglibVariable(fileName, content);
    }

    private String _formatTaglibVariable(String fileName, String content) throws IOException {
        Matcher matcher = _taglibVariablePattern.matcher(content);
        while (matcher.find()) {
            String nextTag = matcher.group(6);
            String taglibValue = matcher.group(4);
            String variableName = matcher.group(3);
            if (!taglibValue.contains("\n") && (taglibValue.contains("\\\"") || taglibValue.contains("'") && taglibValue.contains("\""))) {
                if (variableName.startsWith("taglib") || this._getVariableCount(content, variableName) != 2 || !nextTag.contains("=\"<%= " + variableName + " %>\"")) continue;
                this.addMessage(fileName, "Variable '" + variableName + "' should start with 'taglib'", this.getLineNumber(content, matcher.start(1)));
                continue;
            }
            if (!nextTag.contains("=\"<%= " + variableName + " %>\"")) continue;
            this.populateContentsMap(fileName, content);
            String newContent = null;
            if (taglibValue.startsWith("{")) {
                String typeName = matcher.group(2);
                if (typeName.endsWith("[][]") || !typeName.endsWith("[]")) continue;
                newContent = StringUtil.replaceFirst(content, "<%= " + variableName + " %>\"", StringBundler.concat("<%= new ", typeName, " ", taglibValue, " %>\""), matcher.start(6));
            } else {
                newContent = StringUtil.replaceFirst(content, "<%= " + variableName + " %>\"", "<%= " + taglibValue + " %>\"", matcher.start(6));
            }
            HashSet<String> checkedFileNames = new HashSet<String>();
            HashSet<String> includeFileNames = new HashSet<String>();
            if (!this.hasUnusedJSPTerm(fileName, newContent, "\\W" + variableName + "\\W", "variable", checkedFileNames, includeFileNames, this.getContentsMap())) continue;
            if (!taglibValue.contains("\n")) {
                return StringUtil.replaceFirst(newContent, matcher.group(1), "", matcher.start());
            }
            this.addMessage(fileName, StringBundler.concat("No need to declare variable '", variableName, "', inline inside the tag."), this.getLineNumber(content, matcher.start(3)));
        }
        return content;
    }

    private int _getVariableCount(String content, String variableName) {
        int count = 0;
        Pattern pattern = Pattern.compile("\\W" + variableName + "\\W");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            int x = matcher.start() + 1;
            if (JSPSourceUtil.isJavaSource(content, x)) {
                if (ToolsUtil.isInsideQuotes(content, x)) continue;
                ++count;
                continue;
            }
            if (!JSPSourceUtil.isJavaSource(content, x, true)) continue;
            ++count;
        }
        return count;
    }
}

