/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseLogParametersCheck
extends BaseFileCheck {
    private static final Pattern _logPattern = Pattern.compile("_log\\.(debug|error|fatal|info|trace|warn)\\((.+?)\\);\n", 32);

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    protected String formatLogParameters(String content) {
        Matcher matcher = _logPattern.matcher(content);
        while (matcher.find()) {
            String variableTypeName;
            String firstParameter;
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || !this.isJavaSource(content, matcher.start()) || (parameterList = JavaSourceUtil.getParameterList(matcher.group())).isEmpty() || !Validator.isVariableName(firstParameter = StringUtil.trim(parameterList.get(0))) || (variableTypeName = this.getVariableTypeName(content, content, firstParameter)) == null) continue;
            if (variableTypeName.equals("StringBundler")) {
                return StringUtil.replaceFirst(content, firstParameter, firstParameter + ".toString()", matcher.start(2));
            }
            if (parameterList.size() != 1 || !variableTypeName.endsWith("Exception")) continue;
            return StringUtil.replaceFirst(content, firstParameter, StringBundler.concat(firstParameter, ", ", firstParameter), matcher.start(2));
        }
        return content;
    }

    protected boolean isJavaSource(String content, int pos) {
        return true;
    }
}

