/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LimitedFIFOQueue;
import com.liferay.portal.kernel.util.MethodHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class QueuingInvocationHandler
implements InvocationHandler {
    private static final Log _log = LogFactoryUtil.getLog(QueuingInvocationHandler.class);
    private final LimitedFIFOQueue<MethodHandler> _methodHandlers;

    public QueuingInvocationHandler(int capacity) {
        this._methodHandlers = new LimitedFIFOQueue(capacity);
    }

    public void flush() {
        if (_log.isDebugEnabled()) {
            _log.debug("Flush " + this._methodHandlers.size() + " events from queue");
        }
        this._methodHandlers.clear();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodHandler methodHandler = new MethodHandler(method, args);
        this._methodHandlers.offer(methodHandler);
        return null;
    }

    public void invokeQueued(Object target) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info("Processing " + this._methodHandlers.size() + " queued requests");
        }
        MethodHandler methodHandler = null;
        while ((methodHandler = this._methodHandlers.poll()) != null) {
            methodHandler.invoke(target);
        }
        if (_log.isInfoEnabled()) {
            _log.info("Completed processing queued requests");
        }
    }
}

