/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.office.upgrade.internal.osgi.commands;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.command.function=executeAll", "osgi.command.function=hideTasksLayout", "osgi.command.function=removeTasksPortlet", "osgi.command.function=updateTheme", "osgi.command.scope=socialOffice"}, service={SocialOfficeUpgradeOSGiCommands.class})
public class SocialOfficeUpgradeOSGiCommands {
    private LayoutLocalService _layoutLocalService;
    private LayoutSetLocalService _layoutSetLocalService;
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    public void executeAll() throws PortalException {
        this.hideTasksLayout();
        this.removeTasksPortlet();
        this.updateTheme();
    }

    public void hideTasksLayout() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"friendlyURL", (Object)"/so/tasks"));
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"hidden", (Object)false));
            }
        });
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Layout>(){

            public void performAction(Layout layout) throws PortalException {
                layout.setHidden(true);
                SocialOfficeUpgradeOSGiCommands.this._layoutLocalService.updateLayout(layout);
                atomicInteger.incrementAndGet();
            }
        });
        actionableDynamicQuery.performActions();
        System.out.printf("[socialOffice:hideTasksLayout] %d layouts updated.%n", atomicInteger.get());
    }

    public void removeTasksPortlet() throws PortalException {
        int portletPreferencesCount = this._removeTasksPortletPreferences();
        System.out.printf("[socialOffice:removeTasksPortlet] %d Tasks portlet preferences deleted.%n", portletPreferencesCount);
        int layoutsCount = this._removeTasksPortletLayoutTypeSettings();
        System.out.printf("[socialOffice:removeTasksPortlet] Removed tasks portlet from %d layouts.%n", layoutsCount);
    }

    public void updateTheme() throws PortalException {
        int layoutsCount = this._updateLayoutTheme();
        System.out.printf("[socialOffice:updateTheme] %d layouts updated.%n", layoutsCount);
        int layoutSetsCount = this._updateLayoutSetTheme();
        System.out.printf("[socialOffice:updateTheme] %d layout sets updated.%n", layoutSetsCount);
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesLocalService(PortletPreferencesLocalService portletPreferencesLocalService) {
        this._portletPreferencesLocalService = portletPreferencesLocalService;
    }

    private int _removeTasksPortletLayoutTypeSettings() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                dynamicQuery.add(RestrictionsFactoryUtil.like((String)"typeSettings", (Object)"%tasksportlet%"));
            }
        });
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Layout>(){

            public void performAction(Layout layout) throws PortalException {
                UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
                HashMap modifiedProperties = new HashMap();
                for (Map.Entry entry : typeSettingsProperties.entrySet()) {
                    String value = (String)entry.getValue();
                    if (!value.contains("tasksportlet")) continue;
                    String[] portletIds = StringUtil.split((String)value);
                    ArrayList<String> newPortletIds = new ArrayList<String>();
                    for (String portletId : portletIds) {
                        if (portletId.contains("tasksportlet")) continue;
                        newPortletIds.add(portletId);
                    }
                    modifiedProperties.put(entry.getKey(), StringUtil.merge(newPortletIds));
                }
                typeSettingsProperties.putAll(modifiedProperties);
                layout.setTypeSettingsProperties(typeSettingsProperties);
                SocialOfficeUpgradeOSGiCommands.this._layoutLocalService.updateLayout(layout);
                atomicInteger.incrementAndGet();
            }
        });
        actionableDynamicQuery.performActions();
        return atomicInteger.get();
    }

    private int _removeTasksPortletPreferences() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._portletPreferencesLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                dynamicQuery.add(RestrictionsFactoryUtil.like((String)"portletId", (Object)"%tasksportlet%"));
            }
        });
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<PortletPreferences>(){

            public void performAction(PortletPreferences portletPreferences) throws PortalException {
                SocialOfficeUpgradeOSGiCommands.this._portletPreferencesLocalService.deletePersistedModel((PersistedModel)portletPreferences);
                atomicInteger.incrementAndGet();
            }
        });
        actionableDynamicQuery.performActions();
        return atomicInteger.get();
    }

    private int _updateLayoutSetTheme() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._layoutSetLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"themeId", (Object)"so_WAR_sotheme"));
            }
        });
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<LayoutSet>(){

            public void performAction(LayoutSet layoutSet) throws PortalException {
                layoutSet.setThemeId("classic_WAR_classictheme");
                SocialOfficeUpgradeOSGiCommands.this._layoutSetLocalService.updateLayoutSet(layoutSet);
                atomicInteger.incrementAndGet();
            }
        });
        actionableDynamicQuery.performActions();
        return atomicInteger.get();
    }

    private int _updateLayoutTheme() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"themeId", (Object)"so_WAR_sotheme"));
            }
        });
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Layout>(){

            public void performAction(Layout layout) throws PortalException {
                layout.setThemeId("classic_WAR_classictheme");
                SocialOfficeUpgradeOSGiCommands.this._layoutLocalService.updateLayout(layout);
                atomicInteger.incrementAndGet();
            }
        });
        actionableDynamicQuery.performActions();
        return atomicInteger.get();
    }
}

