/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.activity.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.comparator.ModelResourceComparator;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.social.kernel.model.SocialActivityDefinition;
import com.liferay.social.kernel.model.SocialActivitySetting;
import com.liferay.social.kernel.service.SocialActivitySettingService;
import com.liferay.social.kernel.util.SocialConfigurationUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_social_activity_web_portlet_SocialActivityPortlet", "mvc.command.name=/", "mvc.command.name=/social_activity/view"}, service={MVCRenderCommand.class})
public class ViewMVCRenderCommand
implements MVCRenderCommand {
    private SocialActivitySettingService _socialActivitySettingService;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            renderRequest.setAttribute("SOCIAL_ACTIVITY_SETTINGS_MAP", this.getActivitySettingsMap(themeDisplay));
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return "/view.jsp";
    }

    protected Map<String, Boolean> getActivitySettingsMap(ThemeDisplay themeDisplay) throws Exception {
        LinkedHashMap<String, Boolean> activitySettingsMap = new LinkedHashMap<String, Boolean>();
        List activitySettings = this._socialActivitySettingService.getActivitySettings(themeDisplay.getSiteGroupIdOrLiveGroupId());
        String[] modelNames = SocialConfigurationUtil.getActivityModelNames();
        ModelResourceComparator comparator = new ModelResourceComparator(themeDisplay.getLocale());
        Arrays.sort(modelNames, comparator);
        block0: for (String modelName : modelNames) {
            List activityDefinitions = this._socialActivitySettingService.getActivityDefinitions(themeDisplay.getScopeGroupId(), modelName);
            for (SocialActivityDefinition activityDefinition : activityDefinitions) {
                if (!activityDefinition.isCountersEnabled()) continue;
                activitySettingsMap.put(modelName, false);
                continue block0;
            }
        }
        for (SocialActivitySetting activitySetting : activitySettings) {
            String name = activitySetting.getName();
            if (!name.equals("enabled") || !activitySettingsMap.containsKey(activitySetting.getClassName())) continue;
            activitySettingsMap.put(activitySetting.getClassName(), GetterUtil.getBoolean((String)activitySetting.getValue()));
        }
        return activitySettingsMap;
    }

    @Reference(unbind="-")
    protected void setSocialActivitySettingService(SocialActivitySettingService socialActivitySettingService) {
        this._socialActivitySettingService = socialActivitySettingService;
    }
}

