/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.activity.web.internal.portlet.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.social.kernel.model.SocialActivityCounterDefinition;
import com.liferay.social.kernel.model.SocialActivityDefinition;
import com.liferay.social.kernel.service.SocialActivitySettingService;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_social_activity_web_portlet_SocialActivityPortlet", "mvc.command.name=/social_activity/edit_activity_settings"}, service={MVCActionCommand.class})
public class EditActivitySettingsMVCActionCommand
extends BaseMVCActionCommand {
    private SocialActivitySettingService _socialActivitySettingService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("update")) {
                this.updateActivitySettings(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setSocialActivitySettingService(SocialActivitySettingService socialActivitySettingService) {
        this._socialActivitySettingService = socialActivitySettingService;
    }

    protected SocialActivityCounterDefinition updateActivityCounterDefinition(JSONObject actionJSONObject, SocialActivityDefinition activityDefinition, String activityCounterName) {
        SocialActivityCounterDefinition activityCounterDefinition = activityDefinition.getActivityCounterDefinition(activityCounterName);
        if (activityCounterDefinition == null) {
            activityCounterDefinition = new SocialActivityCounterDefinition();
            activityCounterDefinition.setName(activityCounterName);
        }
        if (activityCounterName.equals("contribution")) {
            activityCounterDefinition.setOwnerType(3);
        } else if (activityCounterName.equals("participation")) {
            activityCounterDefinition.setOwnerType(1);
        } else if (activityCounterName.equals("popularity")) {
            activityCounterDefinition.setOwnerType(2);
            activityCounterName = "contribution";
        } else {
            throw new IllegalArgumentException();
        }
        activityCounterDefinition.setEnabled(actionJSONObject.getBoolean("active"));
        activityCounterDefinition.setIncrement(actionJSONObject.getInt(activityCounterName + "Increment"));
        activityCounterDefinition.setLimitPeriod(actionJSONObject.getInt(activityCounterName + "LimitPeriod"));
        activityCounterDefinition.setLimitValue(actionJSONObject.getInt(activityCounterName + "LimitValue"));
        return activityCounterDefinition;
    }

    protected void updateActivitySettings(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String settingsJSON = ParamUtil.getString((PortletRequest)actionRequest, (String)"settingsJSON");
        JSONObject settingsJSONObject = JSONFactoryUtil.createJSONObject((String)settingsJSON);
        JSONArray actionsJSONArray = settingsJSONObject.getJSONArray("actions");
        String modelName = settingsJSONObject.getString("modelName");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i);
            int activityType = actionJSONObject.getInt("activityType");
            SocialActivityDefinition activityDefinition = this._socialActivitySettingService.getActivityDefinition(themeDisplay.getSiteGroupIdOrLiveGroupId(), modelName, activityType);
            if (activityDefinition == null) continue;
            ArrayList<SocialActivityCounterDefinition> activityCounterDefinitions = new ArrayList<SocialActivityCounterDefinition>();
            activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "contribution"));
            activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "participation"));
            activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "popularity"));
            this._socialActivitySettingService.updateActivitySettings(themeDisplay.getSiteGroupIdOrLiveGroupId(), modelName, activityType, activityCounterDefinitions);
        }
    }
}

