/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.activity.test.util;

import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.test.rule.Inject;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityFeedEntry;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.service.SocialActivityLocalServiceUtil;
import com.liferay.trash.TrashHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class BaseSocialActivityInterpreterTestCase {
    @DeleteAfterTestRun
    protected Group group;
    protected ServiceContext serviceContext;
    @Inject
    protected TrashHelper trashHelper;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setAttribute("COMPANY_ID", (Object)TestPropsValues.getCompanyId());
        httpServletRequest.setAttribute("CURRENT_URL", (Object)"http://localhost:80/web/guest/home");
        httpServletRequest.setAttribute("USER", (Object)TestPropsValues.getUser());
        ServicePreAction servicePreAction = new ServicePreAction();
        servicePreAction.run((HttpServletRequest)httpServletRequest, (HttpServletResponse)new MockHttpServletResponse());
        this.serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
    }

    @Test
    public void testActivityInterpreter() throws Exception {
        this.addActivities();
        long time = System.currentTimeMillis();
        this.renameModels();
        if (this.isSupportsTrash()) {
            this.moveModelsToTrash();
            this.checkLinks();
            this.restoreModelsFromTrash();
        }
        this.checkInterpret(time);
    }

    protected abstract void addActivities() throws Exception;

    protected void checkInterpret(long time) throws Exception {
        List<SocialActivity> activities = this.getActivities();
        Assert.assertFalse((String)activities.toString(), (boolean)activities.isEmpty());
        HashMap<String, String> entryTitles = new HashMap<String, String>();
        SocialActivityInterpreter activityInterpreter = this.getActivityInterpreter();
        for (SocialActivity activity : activities) {
            String title = activity.getExtraDataValue("title", this.serviceContext.getLocale());
            if (this.isSupportsRename(activity.getClassName()) && Validator.isNotNull((String)title)) {
                if (activity.getCreateDate() < time) {
                    entryTitles.put(activity.getClassName(), title);
                } else {
                    Assert.assertNotNull(entryTitles.get(activity.getClassName()));
                    Assert.assertNotEquals(entryTitles.get(activity.getClassName()), (Object)title);
                }
            }
            if (!this.hasClassName(activityInterpreter, activity.getClassName()) || !this.hasActivityType(activity.getType())) continue;
            SocialActivityFeedEntry activityFeedEntry = activityInterpreter.interpret(activity, this.serviceContext);
            Assert.assertNotNull((Object)activityFeedEntry);
            title = activityFeedEntry.getTitle();
            Assert.assertFalse((String)("Title contains parameters: " + title), (boolean)title.matches("\\{\\d\\}"));
        }
    }

    protected void checkLinks() throws Exception {
        List<SocialActivity> activities = this.getActivities();
        Assert.assertFalse((String)activities.toString(), (boolean)activities.isEmpty());
        SocialActivityInterpreter activityInterpreter = this.getActivityInterpreter();
        for (SocialActivity activity : activities) {
            if (!this.hasClassName(activityInterpreter, activity.getClassName()) || !this.hasActivityType(activity.getType())) continue;
            SocialActivityFeedEntry activityFeedEntry = activityInterpreter.interpret(activity, this.serviceContext);
            PortletURL portletURL = this.trashHelper.getViewContentURL(this.serviceContext.getRequest(), activity.getClassName(), activity.getClassPK());
            if (Validator.isNull((String)activityFeedEntry.getLink()) && portletURL == null) continue;
            Assert.assertEquals((Object)portletURL.toString(), (Object)activityFeedEntry.getLink());
        }
    }

    protected List<SocialActivity> getActivities() throws Exception {
        ArrayList<SocialActivity> activities = new ArrayList<SocialActivity>(SocialActivityLocalServiceUtil.getGroupActivities((long)this.group.getGroupId(), (int)-1, (int)-1));
        Collections.reverse(activities);
        return activities;
    }

    protected abstract SocialActivityInterpreter getActivityInterpreter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SocialActivityInterpreter getActivityInterpreter(String portletId, String className) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            BundleContext bundleContext = bundle.getBundleContext();
            Iterator iterator = bundleContext.getServiceReferences(SocialActivityInterpreter.class, "(javax.portlet.name=" + portletId + ")").iterator();
            while (iterator.hasNext()) {
                ServiceReference serviceReference = (ServiceReference)iterator.next();
                SocialActivityInterpreter socialActivityInterpreter = (SocialActivityInterpreter)bundleContext.getService(serviceReference);
                try {
                    if (!ArrayUtil.contains((Object[])socialActivityInterpreter.getClassNames(), (Object)className)) continue;
                    SocialActivityInterpreter socialActivityInterpreter2 = socialActivityInterpreter;
                    return socialActivityInterpreter2;
                }
                finally {
                    bundleContext.ungetService(serviceReference);
                }
            }
            throw new IllegalStateException("No activity interpreter found for class " + className);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected abstract int[] getActivityTypes();

    protected boolean hasActivityType(int activityType) {
        for (int curActivityType : this.getActivityTypes()) {
            if (curActivityType != activityType) continue;
            return true;
        }
        return false;
    }

    protected boolean hasClassName(SocialActivityInterpreter activityInterpreter, String className) {
        for (String curClassName : activityInterpreter.getClassNames()) {
            if (!curClassName.equals(className)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSupportsRename(String className) {
        return true;
    }

    protected boolean isSupportsTrash() {
        return true;
    }

    protected abstract void moveModelsToTrash() throws Exception;

    protected abstract void renameModels() throws Exception;

    protected abstract void restoreModelsFromTrash() throws Exception;
}

