/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.activity.internal.manager;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.social.BaseSocialActivityManager;
import com.liferay.portal.kernel.social.SocialActivityManager;
import com.liferay.social.activity.internal.configuration.SocialActivityCompanyConfiguration;
import com.liferay.social.activity.internal.configuration.SocialActivitySystemConfiguration;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import java.util.Date;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.social.activity.internal.configuration.SocialActivitySystemConfiguration"}, service={SocialActivityManager.class})
public class SocialActivityManagerImpl<T extends ClassedModel & GroupedModel>
implements SocialActivityManager<T> {
    private static final Log _log = LogFactoryUtil.getLog(SocialActivityManagerImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    private SocialActivityManager<T> _defaultSocialActivityManager;
    private ServiceTrackerMap<String, SocialActivityManager<T>> _serviceTrackerMap;
    @Reference
    private SocialActivityLocalService _socialActivityLocalService;
    private SocialActivitySystemConfiguration _socialActivitySystemConfiguration;

    public void addActivity(long userId, T model, int type, String extraData, long receiverUserId) throws PortalException {
        if (!this._isEnabled(((AuditedModel)model).getCompanyId())) {
            return;
        }
        SocialActivityManager<T> socialActivityManager = this._getSocialActivityManager(model.getModelClassName());
        socialActivityManager.addActivity(userId, model, type, extraData, receiverUserId);
    }

    public void addUniqueActivity(long userId, Date createDate, T model, int type, String extraData, long receiverUserId) throws PortalException {
        if (!this._isEnabled(((AuditedModel)model).getCompanyId())) {
            return;
        }
        SocialActivityManager<T> socialActivityManager = this._getSocialActivityManager(model.getModelClassName());
        socialActivityManager.addUniqueActivity(userId, createDate, model, type, extraData, receiverUserId);
    }

    public void addUniqueActivity(long userId, T model, int type, String extraData, long receiverUserId) throws PortalException {
        if (!this._isEnabled(((AuditedModel)model).getCompanyId())) {
            return;
        }
        SocialActivityManager<T> socialActivityManager = this._getSocialActivityManager(model.getModelClassName());
        socialActivityManager.addUniqueActivity(userId, model, type, extraData, receiverUserId);
    }

    public void deleteActivities(T model) throws PortalException {
        SocialActivityManager<T> socialActivityManager = this._getSocialActivityManager(model.getModelClassName());
        socialActivityManager.deleteActivities(model);
    }

    public void updateLastSocialActivity(long userId, T model, int type, Date createDate) throws PortalException {
        if (!this._isEnabled(((AuditedModel)model).getCompanyId())) {
            return;
        }
        SocialActivityManager<T> socialActivityManager = this._getSocialActivityManager(model.getModelClassName());
        socialActivityManager.updateLastSocialActivity(userId, model, type, createDate);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._defaultSocialActivityManager = new BaseSocialActivityManager<T>(){

            protected SocialActivityLocalService getSocialActivityLocalService() {
                return SocialActivityManagerImpl.this._socialActivityLocalService;
            }
        };
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, SocialActivityManager.class, (String)"(model.class.name=*)", (ServiceReferenceMapper)new PropertyServiceReferenceMapper("model.class.name"));
        this._socialActivitySystemConfiguration = (SocialActivitySystemConfiguration)ConfigurableUtil.createConfigurable(SocialActivitySystemConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private SocialActivityManager<T> _getSocialActivityManager(String className) {
        SocialActivityManager socialActivityManager = (SocialActivityManager)this._serviceTrackerMap.getService((Object)className);
        if (socialActivityManager != null) {
            return socialActivityManager;
        }
        return this._defaultSocialActivityManager;
    }

    private boolean _isEnabled(long companyId) {
        try {
            if (!this._socialActivitySystemConfiguration.enableUserSocialActivityTracking()) {
                return false;
            }
            SocialActivityCompanyConfiguration socialActivityCompanyConfiguration = (SocialActivityCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SocialActivityCompanyConfiguration.class, companyId);
            return socialActivityCompanyConfiguration != null && socialActivityCompanyConfiguration.enableUserSocialActivityTracking();
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
            return false;
        }
    }
}

