/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.teams.web.internal.servlet.taglib.util;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class UserActionDropdownItemsProvider {
    private final HttpServletRequest _httpServletRequest;
    private final RenderResponse _renderResponse;
    private final long _teamId;
    private final ThemeDisplay _themeDisplay;
    private final User _user;

    public UserActionDropdownItemsProvider(User user, long teamId, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._user = user;
        this._teamId = teamId;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(UserActionDropdownItemsProvider.this._getDeleteTeamUsersUnsafeConsumer());
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteTeamUsersUnsafeConsumer() {
        PortletURL deleteTeamUsersURL = this._renderResponse.createActionURL();
        deleteTeamUsersURL.setParameter("javax.portlet.action", "deleteTeamUsers");
        deleteTeamUsersURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        deleteTeamUsersURL.setParameter("teamId", String.valueOf(this._teamId));
        deleteTeamUsersURL.setParameter("removeUserId", String.valueOf(this._user.getUserId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "deleteTeamUsers");
            dropdownItem.putData("deleteTeamUsersURL", deleteTeamUsersURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }
}

