/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.teams.web.internal.portlet;

import com.liferay.portal.kernel.exception.DuplicateTeamException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchTeamException;
import com.liferay.portal.kernel.exception.TeamNameException;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.TeamService;
import com.liferay.portal.kernel.service.UserGroupService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-communities", "com.liferay.portlet.icon=/icons/site_teams.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.system=true", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Site Teams", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_site_teams_web_portlet_SiteTeamsPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class SiteTeamsPortlet
extends MVCPortlet {
    private TeamService _teamService;
    private UserGroupService _userGroupService;
    private UserService _userService;

    public void addTeamUserGroups(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long teamId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"teamId");
        long[] addUserGroupIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        this._userGroupService.addTeamUserGroups(teamId, addUserGroupIds);
    }

    public void addTeamUsers(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long teamId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"teamId");
        long[] addUserIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        this._userService.addTeamUsers(teamId, addUserIds);
    }

    public void deleteTeam(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long teamId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"teamId");
        this._teamService.deleteTeam(teamId);
    }

    public void deleteTeams(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] teamIds;
        for (long teamId : teamIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds")) {
            this._teamService.deleteTeam(teamId);
        }
    }

    public void deleteTeamUserGroups(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long teamId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"teamId");
        long[] removeUserGroupIds = null;
        long removeUserGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"removeUserGroupId");
        removeUserGroupIds = removeUserGroupId > 0L ? new long[]{removeUserGroupId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        this._userGroupService.unsetTeamUserGroups(teamId, removeUserGroupIds);
    }

    public void deleteTeamUsers(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long teamId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"teamId");
        long[] removeUserIds = null;
        long removeUserId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"removeUserId");
        removeUserIds = removeUserId > 0L ? new long[]{removeUserId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        this._userService.unsetTeamUsers(teamId, removeUserIds);
    }

    public void editTeam(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long teamId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"teamId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        if (teamId <= 0L) {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Team.class.getName(), (PortletRequest)actionRequest);
            this._teamService.addTeam(themeDisplay.getSiteGroupId(), name, description, serviceContext);
        } else {
            this._teamService.updateTeam(teamId, name, description);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof DuplicateTeamException || cause instanceof NoSuchGroupException || cause instanceof NoSuchTeamException || cause instanceof PrincipalException || cause instanceof TeamNameException || super.isSessionErrorException(cause);
    }

    @Reference(unbind="-")
    protected void setTeamService(TeamService teamService) {
        this._teamService = teamService;
    }

    @Reference(unbind="-")
    protected void setUserGroupService(UserGroupService userGroupService) {
        this._userGroupService = userGroupService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }
}

