/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.teams.web.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_site_teams_web_portlet_SiteTeamsPortlet"}, service={StagedModelDataHandler.class})
public class TeamStagedModelDataHandler
extends BaseStagedModelDataHandler<Team> {
    public static final String[] CLASS_NAMES = new String[]{Team.class.getName()};
    private TeamLocalService _teamLocalService;
    private UserGroupLocalService _userGroupLocalService;
    private UserLocalService _userLocalService;

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Team team = this._teamLocalService.fetchTeamByUuidAndGroupId(uuid, groupId);
        if (team != null) {
            this.deleteStagedModel(team);
        }
    }

    public void deleteStagedModel(Team team) throws PortalException {
        this._teamLocalService.deleteTeam(team);
    }

    public void doExportStagedModel(PortletDataContext portletDataContext, Team team) throws Exception {
        List teamUserGroups;
        Element teamElement = portletDataContext.getExportDataElement((ClassedModel)team);
        List teamUsers = this._userLocalService.getTeamUsers(team.getTeamId());
        if (ListUtil.isNotEmpty((List)teamUsers)) {
            for (User user : teamUsers) {
                portletDataContext.addReferenceElement((ClassedModel)team, teamElement, (ClassedModel)user, "weak", true);
            }
        }
        if (ListUtil.isNotEmpty((List)(teamUserGroups = this._userGroupLocalService.getTeamUserGroups(team.getTeamId())))) {
            for (UserGroup userGroup : teamUserGroups) {
                portletDataContext.addReferenceElement((ClassedModel)team, teamElement, (ClassedModel)userGroup, "weak", true);
            }
        }
        portletDataContext.addClassedModel(teamElement, ExportImportPathUtil.getModelPath((StagedModel)team), (ClassedModel)team);
    }

    public Team fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._teamLocalService.fetchTeamByUuidAndGroupId(uuid, groupId);
    }

    public List<Team> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._teamLocalService.getTeamsByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Team team) throws Exception {
        Team existingTeam = this.fetchExistingTeam(team.getUuid(), portletDataContext.getScopeGroupId(), team.getName());
        Team importedTeam = null;
        if (existingTeam == null) {
            long userId = portletDataContext.getUserId(team.getUserUuid());
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)team);
            serviceContext.setUuid(team.getUuid());
            importedTeam = this._teamLocalService.addTeam(userId, portletDataContext.getScopeGroupId(), team.getName(), team.getDescription(), serviceContext);
        } else {
            importedTeam = this._teamLocalService.updateTeam(existingTeam.getTeamId(), team.getName(), team.getDescription());
        }
        List userElements = portletDataContext.getReferenceElements((StagedModel)team, User.class);
        for (Element userElement : userElements) {
            long companyId = GetterUtil.getLong((String)userElement.attributeValue("company-id"));
            String uuid = userElement.attributeValue("uuid");
            User user = this._userLocalService.fetchUserByUuidAndCompanyId(uuid, companyId);
            if (user == null || this._userLocalService.hasTeamUser(importedTeam.getTeamId(), user.getUserId())) continue;
            this._userLocalService.addTeamUser(importedTeam.getTeamId(), user);
        }
        List userGroupElements = portletDataContext.getReferenceElements((StagedModel)team, UserGroup.class);
        for (Element userGroupElement : userGroupElements) {
            long companyId = GetterUtil.getLong((String)userGroupElement.attributeValue("company-id"));
            String uuid = userGroupElement.attributeValue("uuid");
            UserGroup userGroup = this._userGroupLocalService.fetchUserGroupByUuidAndCompanyId(uuid, companyId);
            if (userGroup == null || this._userGroupLocalService.hasTeamUserGroup(importedTeam.getTeamId(), userGroup.getUserGroupId())) continue;
            this._userGroupLocalService.addTeamUserGroup(importedTeam.getTeamId(), userGroup);
        }
        portletDataContext.importClassedModel((ClassedModel)team, (ClassedModel)importedTeam);
    }

    protected Team fetchExistingTeam(String uuid, long groupId, String name) {
        Team team = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (team != null) {
            return team;
        }
        return this._teamLocalService.fetchTeam(groupId, name);
    }

    protected boolean isSkipImportReferenceStagedModels() {
        return true;
    }

    @Reference(unbind="-")
    protected void setTeamLocalService(TeamLocalService teamLocalService) {
        this._teamLocalService = teamLocalService;
    }

    @Reference(unbind="-")
    protected void setUserGroupLocalService(UserGroupLocalService userGroupLocalService) {
        this._userGroupLocalService = userGroupLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

