/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.teams.web.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_site_teams_web_portlet_SiteTeamsPortlet"}, service={PortletDataHandler.class})
public class SiteTeamsPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "site_teams";
    public static final String SCHEMA_VERSION = "1.0.0";
    @Reference
    private Staging _staging;
    private TeamLocalService _teamLocalService;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    @Activate
    protected void activate() {
        this.setDataAlwaysStaged(true);
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "teams", true, true, null, Team.class.getName())});
        this.setPublishToLiveByDefault(true);
        this.setRank(80);
        this.setStagingControls(this.getExportControls());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(SiteTeamsPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._teamLocalService.deleteTeams(portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ExportActionableDynamicQuery actionableDynamicQuery = this._teamLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        Element teamsElement = portletDataContext.getImportDataGroupElement(Team.class);
        List teamElements = teamsElement.elements();
        for (Element teamElement : teamElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)teamElement);
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(Team.class.getName())});
            return;
        }
        ExportActionableDynamicQuery actionableDynamicQuery = this._teamLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.performCount();
    }

    @Reference(unbind="-")
    protected void setTeamLocalService(TeamLocalService teamLocalService) {
        this._teamLocalService = teamLocalService;
    }
}

