/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.teams.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.service.TeamServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.teams.web.internal.search.TeamSearch;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class SiteTeamsDisplayContext {
    private String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public SiteTeamsDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest httpServletRequest) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = httpServletRequest;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        return portletURL;
    }

    public SearchContainer getSearchContainer() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TeamSearch searchContainer = new TeamSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        searchContainer.setEmptyResultsMessage("there-are-no-teams");
        searchContainer.setId("teams");
        searchContainer.setOrderByCol(this.getOrderByCol());
        searchContainer.setOrderByType(this.getOrderByType());
        searchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        int total = TeamServiceUtil.searchCount((long)themeDisplay.getScopeGroupId(), (String)this.getKeywords(), (String)this.getKeywords(), new LinkedHashMap());
        searchContainer.setTotal(total);
        List results = TeamServiceUtil.search((long)themeDisplay.getScopeGroupId(), (String)this.getKeywords(), (String)this.getKeywords(), new LinkedHashMap(), (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator());
        searchContainer.setResults(results);
        return searchContainer;
    }

    public boolean isDescriptiveView() {
        return Objects.equals(this.getDisplayStyle(), "descriptive");
    }

    public boolean isListView() {
        return Objects.equals(this.getDisplayStyle(), "list");
    }

    protected String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
        return this._keywords;
    }
}

