/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.teams.web.internal.display.context;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.sitesadmin.search.UserGroupTeamChecker;
import com.liferay.portlet.usergroupsadmin.search.UserGroupDisplayTerms;
import com.liferay.portlet.usergroupsadmin.search.UserGroupSearch;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class SelectUserGroupsDisplayContext {
    private String _displayStyle;
    private String _eventName;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private String _redirect;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private Team _team;
    private Long _teamId;
    private SearchContainer _userGroupSearchContainer;

    public SelectUserGroupsDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest httpServletRequest) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = httpServletRequest;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getEventName() {
        if (this._eventName != null) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"eventName", (String)(this._renderResponse.getNamespace() + "selectUserGroup"));
        return this._eventName;
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_user_groups.jsp");
        portletURL.setParameter("redirect", this.getRedirect());
        portletURL.setParameter("teamId", String.valueOf(this.getTeamId()));
        portletURL.setParameter("eventName", this.getEventName());
        String keywords = this.getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        return this._redirect;
    }

    public Team getTeam() {
        if (this._team != null) {
            return this._team;
        }
        this._team = TeamLocalServiceUtil.fetchTeam((long)this.getTeamId());
        return this._team;
    }

    public long getTeamId() {
        if (this._teamId != null) {
            return this._teamId;
        }
        this._teamId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"teamId");
        return this._teamId;
    }

    public SearchContainer getUserGroupSearchContainer() {
        if (this._userGroupSearchContainer != null) {
            return this._userGroupSearchContainer;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UserGroupSearch userGroupSearchContainer = new UserGroupSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        OrderByComparator orderByComparator = UsersAdminUtil.getUserGroupOrderByComparator((String)this.getOrderByCol(), (String)this.getOrderByType());
        userGroupSearchContainer.setOrderByCol(this.getOrderByCol());
        userGroupSearchContainer.setOrderByComparator(orderByComparator);
        userGroupSearchContainer.setOrderByType(this.getOrderByType());
        Team team = this.getTeam();
        userGroupSearchContainer.setRowChecker((RowChecker)new UserGroupTeamChecker(this._renderResponse, team));
        UserGroupDisplayTerms searchTerms = (UserGroupDisplayTerms)userGroupSearchContainer.getSearchTerms();
        LinkedHashMap<String, Long> userGroupParams = new LinkedHashMap<String, Long>();
        Group group = GroupLocalServiceUtil.fetchGroup((long)team.getGroupId());
        if (group != null) {
            group = StagingUtil.getLiveGroup((long)group.getGroupId());
        }
        userGroupParams.put("userGroupsGroups", group.getGroupId());
        int userGroupsCount = UserGroupLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), userGroupParams);
        userGroupSearchContainer.setTotal(userGroupsCount);
        List userGroups = UserGroupLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), userGroupParams, (int)userGroupSearchContainer.getStart(), (int)userGroupSearchContainer.getEnd(), (OrderByComparator)userGroupSearchContainer.getOrderByComparator());
        userGroupSearchContainer.setResults(userGroups);
        this._userGroupSearchContainer = userGroupSearchContainer;
        return this._userGroupSearchContainer;
    }
}

