/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.teams.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.TeamNameComparator;
import com.liferay.site.teams.web.internal.search.TeamDisplayTerms;
import com.liferay.site.teams.web.internal.search.TeamSearch;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class SelectTeamDisplayContext {
    private String _displayStyle;
    private String _eventName;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private SearchContainer _teamSearchContainer;

    public SelectTeamDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest httpServletRequest) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = httpServletRequest;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getEventName() {
        if (this._eventName != null) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"eventName", (String)(this._renderResponse.getNamespace() + "selectTeam"));
        return this._eventName;
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_team.jsp");
        portletURL.setParameter("eventName", this.getEventName());
        String keywords = this.getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public SearchContainer getTeamSearchContainer() {
        if (this._teamSearchContainer != null) {
            return this._teamSearchContainer;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TeamSearch teamSearchContainer = new TeamSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        teamSearchContainer.setOrderByCol(this.getOrderByCol());
        boolean orderByAsc = false;
        if (Objects.equals(this.getOrderByType(), "asc")) {
            orderByAsc = true;
        }
        teamSearchContainer.setOrderByComparator((OrderByComparator)new TeamNameComparator(orderByAsc));
        teamSearchContainer.setOrderByType(this.getOrderByType());
        TeamDisplayTerms searchTerms = (TeamDisplayTerms)teamSearchContainer.getSearchTerms();
        int teamsCount = TeamLocalServiceUtil.searchCount((long)themeDisplay.getScopeGroupId(), (String)searchTerms.getKeywords(), (String)searchTerms.getKeywords(), new LinkedHashMap());
        teamSearchContainer.setTotal(teamsCount);
        List teams = TeamLocalServiceUtil.search((long)themeDisplay.getScopeGroupId(), (String)searchTerms.getKeywords(), (String)searchTerms.getKeywords(), new LinkedHashMap(), (int)teamSearchContainer.getStart(), (int)teamSearchContainer.getEnd(), (OrderByComparator)teamSearchContainer.getOrderByComparator());
        teamSearchContainer.setResults(teams);
        this._teamSearchContainer = teamSearchContainer;
        return this._teamSearchContainer;
    }
}

